#!/bin/bash -f

cd /tmp
ADMIN_USER="$1"
ADMIN_UID="$2"
#Identifying the os
if [ -f /etc/os-release ]; then
    . /etc/os-release
    distros_version="$VERSION_ID"
    case "$ID" in
        "rhel")
            distros="rhel"
            distros_major_vers="$(echo $distros_version | awk -F '.' '{print $1}')"
            ;;
        "centos")
            distros="centos"
            distros_major_vers="$VERSION_ID"
            ;;
        "ubuntu")
            distors="ubuntu"
            distros_major_vers="$(echo $distros_version | awk -F '.' '{print $1}')"
            ;;
        "almalinux")
            distros="almalinux"
            distros_major_vers="$VERSION_ID"
            ;;
        "amzn")
            distros="amzn"
            distros_major_vers="$VERSION_ID"
            ;;
        "rocky")
            distros="rocky"
            distros_major_vers="$VERSION_ID"
            ;;
    esac
else
    if grep -qi "red hat" /etc/redhat-release ; then
        distros="rhel"
        distros_version=$(awk '{print $6}' /etc/redhat-release)
    fi
    if [ -f /etc/centos-release ] ; then
        distros="centos"
        distros_version=$(awk '{print $4}' /etc/centos-release | awk -F '.' '{print $1}')
    fi
    if grep -qi "ubuntu" /etc/lsb-release ; then
        distros="ubuntu"
        distros_version=$(grep "DISTRIB_RELEASE" /etc/lsb-release | cut -d'=' -f2)
    fi
    if grep -qi "almalinux" /etc/redhat-release; then
        distros="almalinux"
        distros_version=$(awk '{print $7}' /etc/redhat-release)
    fi
    if grep -qi "Rocky Linux" /etc/rocky-release; then
        distros="rocky"
        distros_version=$(awk '{print $4}' /etc/rocky-release )
    fi
fi

case "$distros" in 
    "rhel")
        PKG_MAN="yum"
        $PKG_MAN check-update --skip-broken -y 
        $PKG_MAN install -y yum-utils
        # installing epel-release
        $PKG_MAN install -y wget  
        wget https://dl.fedoraproject.org/pub/epel/epel-release-latest-${distros_major_vers}.noarch.rpm
        rpm -ivh epel-release-latest-${distros_major_vers}.noarch.rpm
        $PKG_MAN install -y patchelf 
        $PKG_MAN install -y dbus nfs-utils net-tools zlib-devel openssl-devel bind-utils
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y ypbind
        $PKG_MAN install -y which csh
        $PKG_MAN install -y sudo
        # for criu
        $PKG_MAN install -y asciidoc xmlto libbsd-devel libnet protobuf protobuf-c protobuf-c-devel protobuf-compiler libnl3-devel libcap-devel python3 nftables
        $PKG_MAN install -y libnet
        #disabling selinux
        status=$(sudo getenforce)
        if [[ "$status" == "Enforcing" || "$status" == "Permissive" ]]; then
            sed -i 's/^SELINUX=.*/SELINUX=disabled/' /etc/selinux/config
        fi
        ;;
    "rocky")
        PKG_MAN="yum"
        $PKG_MAN check-update --skip-broken -y
        $PKG_MAN install -y yum-utils
        # installing epel-release
        $PKG_MAN install -y wget
        wget https://dl.fedoraproject.org/pub/epel/epel-release-latest-${distros_major_vers}.noarch.rpm
        rpm -ivh epel-release-latest-${distros_major_vers}.noarch.rpm
        $PKG_MAN install -y patchelf
        $PKG_MAN install -y dbus nfs-utils net-tools zlib-devel openssl-devel bind-utils
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y ypbind
        $PKG_MAN install -y which csh
        $PKG_MAN install -y sudo
        # for criu
        $PKG_MAN install -y asciidoc xmlto libnet protobuf protobuf-c protobuf-c-devel protobuf-compiler libnl3-devel libcap-devel python3 nftables
        dnf install -y epel-release
        dnf install libbsd-devel
        $PKG_MAN install -y libnet
        #disabling selinux
        status=$(sudo getenforce)
        if [[ "$status" == "Enforcing" || "$status" == "Permissive" ]]; then
            sed -i 's/^SELINUX=.*/SELINUX=disabled/' /etc/selinux/config
        fi
        ;;
    "centos")
        PKG_MAN="yum"
        if [[ "${distros_major_vers}" != "9" ]] ; then
            sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/mirror.centos.org/vault.centos.org/g' {} +
            sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^#.*baseurl=http/baseurl=http/g' {} +
            sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^mirrorlist=http/#mirrorlist=http/g' {} +
        fi
        $PKG_MAN check-update --skip-broken -y
        $PKG_MAN install -y yum-utils epel-release
        $PKG_MAN install -y patchelf
        $PKG_MAN install -y ypbind
        $PKG_MAN install -y dbus nfs-utils net-tools zlib-devel openssl-devel bind-utils
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y asciidoc xmlto libbsd-devel libnet protobuf protobuf-c protobuf-c-devel protobuf-compiler libnl3-devel libcap-devel python3 nftables
        $PKG_MAN install -y wget libnet
        ;;
    "ubuntu")
        PKG_MAN="apt-get" 
        $PKG_MAN update -y
        $PKG_MAN install -y patchelf
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y nis
	;;
    "almalinux")
        PKG_MAN="yum"
        $PKG_MAN check-update --skip-broken -y
        $PKG_MAN install -y yum-utils epel-release
        $PKG_MAN install -y patchelf
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y ypbind
        $PKG_MAN install -y dbus nfs-utils net-tools zlib-devel openssl-devel bind-utils
        $PKG_MAN install -y asciidoc xmlto libbsd-devel libnet protobuf protobuf-c protobuf-c-devel protobuf-compiler libnl3-devel libcap-devel python3 nftables
        $PKG_MAN install -y wget libnet
        ;;
    "amzn")
        $PKG_MAN check-update --skip-broken -y 
        PKG_MAN="yum"
        $PKG_MAN amazon-linux-extras install -y epel
        $PKG_MAN install -y yum-utils 
        $PKG_MAN install -y patchelf
        $PKG_MAN install -y cachefilesd
        $PKG_MAN install -y ypbind
        $PKG_MAN install -y dbus nfs-utils net-tools zlib-devel openssl-devel bind-utils
        $PKG_MAN install -y which csh 
        $PKG_MAN install -y sudo
        # for criu
        $PKG_MAN install -y asciidoc xmlto libbsd-devel libnet protobuf protobuf-c protobuf-c-devel protobuf-compiler libnl3-devel libcap-devel python3 nftables
        $PKG_MAN install -y wget libnet
        ;;
esac

if [[ -f /etc/redhat-release ]] && grep -qi "red hat" /etc/redhat-release; then
    #Remove sssd_cache
    cp -r /var/lib/sss/db /var/lib/sss/db.bak
    rm -rf /var/lib/sss/db/*
    sss_cache -E
fi

#Removing AMI INFO like users, user home directory 
#for user in $(cut -d: -f1 /etc/passwd); do
#    uid=$(id -u "$user" 2>/dev/null)
#    if [[ $uid -ge 1000 ]]; then
#        echo "Removing user: $user"
#        userdel -r "$user"
#    fi
#done

#adding admin user 
if id -u "${ADMIN_USER}" >/dev/null 2>&1; then
    existing_uid=$(id -u "${ADMIN_USER}")
    if [ "$existing_uid" -eq "${ADMIN_UID}" ]; then
        echo "User ${ADMIN_USER} already exists with matching UID ${ADMIN_UID}."
    else
        echo "User ${ADMIN_USER} exists but with a different UID: ${existing_uid}."
    fi
else
    case "$distros" in
        rhel|centos|almalinux|amzn)
            useradd --uid "${ADMIN_UID}" --no-create-home "${ADMIN_USER}"
            ;;
        ubuntu)
            adduser --uid "${ADMIN_UID}" --no-create-home --gecos GECOS --disabled-password "${ADMIN_USER}"
            ;;
        *)
            echo "Unsupported distribution: $distros"
            ;;
    esac
fi

#Generating sudoers file
sudo tee /etc/sudoers <<EOF
Defaults        env_reset
Defaults        mail_badpass
Defaults        secure_path=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/snap/bin

# User privilege specification
root    ALL=(ALL:ALL) ALL

# Members of the admin group may gain root privileges
%admin ALL=(ALL) ALL

# Allow members of group sudo to execute any command
%sudo   ALL=(ALL:ALL) ALL
Defaults !pam_session
# Without LDAP 
${ADMIN_USER} ALL=(ALL) NOPASSWD:ALL
EOF
chmod 600 /etc/sudoers
chown root:root /etc/sudoers


#criu setup
if [ "$distros" == "centos" ]; then
    echo "Installing CRIU"
    (cd /tmp/; curl -O https://s3.us-west-1.amazonaws.com/spillbox.io-public/criu_centos7/criu.tar; tar xvf criu.tar; cp static/criu /usr/bin/criu; ls -al /usr/bin/criu)
else
    echo "Installing CRIU"
    (cd /tmp/; wget https://s3.us-west-1.amazonaws.com/spillbox.io-public/criu/criu.tar; tar xvf criu.tar; sudo cp static/criu /usr/bin/criu)
fi

#if [ "$distros" == "rhel" ] || [ "$distros" == "rocky" ]; then
#    sudo setcap cap_chown,cap_dac_override,cap_dac_read_search,cap_fowner,cap_sys_ptrace,cap_sys_admin,cap_sys_resource,cap_checkpoint_restore=+eip /usr/bin/criu
#else
#    sudo setcap cap_chown,cap_dac_override,cap_dac_read_search,cap_fowner,cap_fsetid,cap_kill,cap_setgid,cap_setuid,cap_setpcap,cap_linux_immutable,cap_net_bind_service,cap_net_broadcast,cap_net_admin,cap_net_raw,cap_ipc_lock,cap_ipc_owner,cap_sys_module,cap_sys_rawio,cap_sys_chroot,cap_sys_ptrace,cap_sys_pacct,cap_sys_admin,cap_sys_boot,cap_sys_nice,cap_sys_resource,cap_sys_time,cap_sys_tty_config,cap_mknod,cap_lease,cap_setfcap,cap_mac_override,cap_mac_admin,cap_syslog=+eip /usr/bin/criu
#fi

