#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

if [ "$SPILLBOX_DEBUG" != "" ] ; then
    set -x
fi
if [ "$LSF_DOCKERIZED_CLUSTER" == "true" ]; then
        sudocmd=""
        id=$(id -u)
        if [ "$id" == "0" ]; then
            sudocmd="sudo"
        else
            CAN_I_RUN_SUDO=$(sudo -n uptime 2>&1|grep "load"|wc -l)
            if [ $(($CAN_I_RUN_SUDO)) -gt 0 ]; then
                sudocmd="sudo"
            else
                sudocmd="/bin/true"
            fi
        fi
        $sudocmd sh -c "echo \"ALL ALL=(ALL) NOPASSWD: /bin/mkdir, /usr/bin/mkdir, /bin/mount, /usr/bin/mount\" >> /etc/sudoers"
fi

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
STANDALONE_SETUP=0
#checking the standalone setup file if exist script is invoked from customer work area which is used for standalone execution setup
if [ -f  $DIR/standalone_setup.sh ]; then
    STANDALONE_SETUP=1
    source $DIR/standalone_setup.sh
fi

export SPILLBOX_SPLWRAPPER=1
if [ "$SPILLBOX_SITE" == "" ] ; then
    echo "SPILLBOX_SITE not set"  >& 2
    exit 3
fi

if [[ "${SPILLBOX_WORKDIR}" == "" && "$LS_EXECCWD" != "" ]]; then
    export SPILLBOX_WORKDIR=$LS_EXECCWD
fi
export SPILLBOX_BAPP=1 
if [[ ${SPILLBOX_CLOUD_USER} == *".."* ]]; then
    echo "Unexpected var value!!"  >& 2
    exit 3
else
    if [[ ${SPILLBOX_CLOUD_USER} == *"/"* ]]; then
        echo "Unexpected var value!!"  >& 2
        exit 3
    fi
fi
if [[ ${SPILLBOX_PROJECT} == *".."* ]]; then
    echo "Unexpected var value!!"  >& 2
    exit 3
else
    if [[ ${SPILLBOX_PROJECT} == *"/"* ]]; then
        echo "Unexpected var value!!"  >& 2
        exit 3
    fi
fi

export LOGNAME=${SPILLBOX_CLOUD_USER}
if test $STANDALONE_SETUP -eq 0 ; then
    setup_file="/spillbox_workdir/.spillbox/sites/local/${SPILLBOX_SITE}/sites/local/customers/conf/${SPILLBOX_CLOUD_USER}-${SPILLBOX_PROJECT}"
else
    setup_file="${DIR}/standalone_setup.sh"
fi
if [ -f  $setup_file ]; then
    . $setup_file
    declare -A arr
    var=0
    for i in "$@"; do
        if [[ "${!var}" == ">" ]] || [[ "${!var}" == "1>" ]] || [[ "${!var}" == "2>" ]]; then
        ### /dev/null has to be handled??
            if [[ "${!var}" == "2>" ]]; then
                ((var=var+1))
                export SPLAPP_STDERR=${!var}
            else
                ((var=var+1))
                if [[ "$SPLAPP_STDOUT" == "" ]]; then
                    export SPLAPP_STDOUT=${!var}
                fi
            fi
            continue
        elif [[ "$i" == ">" ]] || [[ "$i" == "1>" ]] || [[ "$i" == "2>" ]] || [[ "$i" == "2>&1" ]]; then
            if [[ "$i" == "2>&1" ]]; then
                export SPLAPP_STDERR='&1'
            fi
            ((var=var+1))
            continue
        fi
        ((var=var+1))
        arr[$var]=$i
    done
    if [ "$SPILLBOX_INPUT_CMD" != "" ]; then
        arr=()
        arr[0]="${SPILLBOX_INPUT_CMD}"
        if [[ "$LSF_DOCKERIZED_CLUSTER" == "true" ]]; then
                export SPLAPP_USER_BIN_CMD="${arr[@]}"
        fi
        unset SPILLBOX_INPUT_CMD
    fi
    if [[ "$LSF_DOCKERIZED_CLUSTER" == "true" ]] || [[ "$NC_DOCKERIZED_CLUSTER" == "true" ]]; then
        exec $DIR/tini -s -g -p SIGTERM -- $DIR/entrypoint.sh $DIR/exewrapper.sh "${arr[@]}"
    else
        exec $DIR/entrypoint.sh $DIR/exewrapper.sh "${arr[@]}"
    fi
else
    echo "$setup_file not found" >&2
    exit 3
fi

