#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

echo "###############################################################"
echo "#	STARTING ENCRYPTION SCRIPT                                 #"
echo "###############################################################"
echo

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd $DIR/../release

ChkInstalledShc=($( which shc ))
if [ "${#ChkInstalledShc[@]}" != "1" ] ; then
  echo "Check if shc is installed"
  echo "Encryption aborted.."
  exit -1
fi

case $1 in
     encrypt|e) 
       echo `pwd`
       ListOfShellFilesToEncrypt=($( cat ./cli_files_enc.list ))
       ShCount=${#ListOfShellFilesToEncrypt[@]}
       echo "Total files to encrypt"
       echo "$ShCount  ${ListOfShellFilesToEncrypt[@]}"
       tar -cvf ./modified_sh_files.tar ./cli_files_enc.list
       echo "Starting loop ..."
       for i in ${ListOfShellFilesToEncrypt[@]}
        do 
          # echo "Encrypting $i"
          if test -f "$i" ; then
             echo "Encrypting $i"
             tar -rf ./modified_sh_files.tar $i
             #export CFLAGS=-g 
             echo "shc -f $i"
	     if test -L "$i" ; then
		     continue
	     fi
             shc -r -f $i
             echo "mv $i{,.remove}"
             mv $i{,.remove}
             echo "mv $i.x $i"
             mv $i.x $i
       else
	    echo "No File $i"
	    
       fi
       done
       echo "Cleaning up..."
       find . -type f \( -name "*.remove" -o -name "*.c" \) -exec rm {} \;
     ;;
esac  
 
 echo "Total number of scripts"
 tar -tvf ./modified_sh_files.tar | wc -l
 echo "Total files submitted to encrypt"
 echo $ShCount  
 
echo "Finished Encrypting files"
