#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

if [ "$SPLAPP_DEBUG" != "" ]; then
    set -x
fi
if [ "$SPILLBOX_SPLWRAPPER" != "" ] ; then
    echo "This is remote, not local" >&2
    exit 1
fi
host=$(hostname)
if [[ "$SPLAPP_MULTICLUSTER_GATEWAY" == "$host" && "$SPILLBOX_PROJECT" != "" ]] ; then
    if [ "$SPLAPP_CLIENT_HOME" == "" ] ; then
        echo "SPLAPP_CLIENT_HOME not set" >&2
        exit 1
    fi
    
    IN="$@"
    if [ "$SPLAPP_USER_CMD" != "" ]; then
        IN="$SPLAPP_USER_CMD"
    fi
    IFS=' ' read -r -a cmd <<< $IN
    if [[ ${#cmd[@]} -gt 2 ]] ; then
        if [[ ${cmd[0]} =~ /bin/sh|/bin/bash|/bin/csh|/bin/dash|/bin/zsh && "${cmd[1]}" == "-c" ]]; then
            args="${cmd[@]:2}"
            exec $SPLAPP_CLIENT_HOME/splrun brun $SPLAPP_SPLRUN_OPTION $SPLAPP_MULTICLUSTER_OPTION "$SPLAPP_MULTICLUSTER_ARGS" ${cmd[0]} ${cmd[1]} "$args"
        fi
    fi
    exec  $SPLAPP_CLIENT_HOME/splrun brun $SPLAPP_SPLRUN_OPTION $SPLAPP_MULTICLUSTER_OPTION "$SPLAPP_MULTICLUSTER_ARGS"  $IN
else
    IN="$@"
    IFS=' ' read -r -a cmd <<< $IN
    if [[ ${#cmd[@]} -gt 2 ]] ; then
        if [[ ${cmd[0]} =~ /bin/sh|/bin/bash|/bin/csh|/bin/dash|/bin/zsh && "${cmd[1]}" == "-c" ]]; then
            args="${cmd[@]:2}"
            exec $SPLAPP_CLIENT_HOME/exewrapper.sh ${cmd[0]} ${cmd[1]} "$args"
        fi
    fi
    exec  $SPLAPP_CLIENT_HOME/exewrapper.sh /bin/sh -c "$@"
fi
