#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

usage()
{
    echo "Usage : $0 [-kill|-xrdp|-help]"
}

if test "$#" -gt 1; then
    usage;
    exit 0;
fi

XRDP=
KILL=
if test "$#" -gt 0; then
    if [ "$1" == "-kill" ]; then
        KILL=1;
    else
        if [ "$1" == "-xrdp" ]; then
            XRDP=1;
        else
            if [ "$1" == "-help" ]; then
                usage;
                exit 0;
            fi
        fi
    fi
fi

if [ "${SPILLBOX_VPN}" != "" ]; then
    echo "This is not supported in VPN flow"
fi

SPLDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
	
#
centos=0
APT="apt-get"
$SPLDIR/splrun run ls  /etc/centos-release >& /dev/null
RETVAL=$?
if test ${RETVAL} -eq 0 ; then
	centos=1
	APT="yum"
fi

set -e

if test $centos -eq 1 ; then
	$SPLDIR/splrun run sudo $APT -y install epel-release
	$SPLDIR/splrun run sudo $APT -y groupinstall X11
	$SPLDIR/splrun run sudo $APT -y groups install "Xfce"
fi
if test $centos -eq 1 ; then
	$SPLDIR/splrun run sudo $APT -y install tigervnc-server
else
	$SPLDIR/splrun run sudo $APT -y install tigervnc-xorg-extension tigervnc-standalone-server tigervnc-scraping-server tigervnc-common
fi

#$SPLDIR/splrun run sudo cat ~/.vnc/xstartup 

#

unset XDG_RUNTIME_DIR XAUTHORITY GPG_AGENT_INFO SSH_AUTH_SOCK DBUS_SESSION_BUS_ADDRESS   

if [ "$XRDP" == "1" ]; then
    echo "$SPLDIR/splrun run sudo $APT -y install xrdp"
    $SPLDIR/splrun run sudo $APT -y install xrdp
    echo "$SPLDIR/splrun run sudo systemctl enable xrdp"
    $SPLDIR/splrun run sudo systemctl enable xrdp
    echo "$SPLDIR/splrun run echo xfce4-session \>~/.xsession"
    $SPLDIR/splrun run echo xfce4-session \>~/.xsession
    echo "$SPLDIR/splrun run sudo service xrdp restart"
    $SPLDIR/splrun run sudo service xrdp restart
    IP=$($SPLDIR/splrun run hostname -i | tr -d '\r')
    echo "$SPLDIR/splrun project  vnctunnel -vnc rdp -number 0 ${IP}"
    $SPLDIR/splrun project  vnctunnel -vnc rdp -number 0 ${IP}
else
    
    echo "$SPLDIR/splrun run vncserver"
    $SPLDIR/splrun run pkill Xvnc || true
    $SPLDIR/splrun run vncserver -kill :1 >& /dev/null || true
    $SPLDIR/splrun run vncserver -kill :2 >& /dev/null || true
    $SPLDIR/splrun run echo "startxfce4 \&" \>\> \~/.vnc/xstartup
    sleep 30
    if test $centos -eq 1 ; then
        VNCNUM=$($SPLDIR/splrun run vncserver -SecurityTypes None | grep ^New | awk -F"desktop" '{print $2}' | awk -F":" '{print $2}' |  awk '{print $1}' | tr -d '\r')
    else
        VNCNUM=$($SPLDIR/splrun run vncserver -SecurityTypes None -localhost no --I-KNOW-THIS-IS-INSECURE | grep ^New | awk -F"desktop" '{print $2}' | awk -F":" '{print $2}' | awk '{print $1}' | tr -d '\r')
    fi
    IP=$($SPLDIR/splrun run hostname -i | awk '{print $1}' | tr -d '\r')
    echo "$SPLDIR/splrun project  vnctunnel -vnc tigervnc -number $VNCNUM ${IP}"
    VNCSERVER=$($SPLDIR/splrun project  vnctunnel -vnc tigervnc -number $VNCNUM ${IP})
    LNUM=$(echo $VNCSERVER | awk -F: '{print $3}')
    host=$(hostname)
    echo "#INFO: VNC server $host:$LNUM"
    if [ -x /usr/bin/xtigervncviewer ]; then
        echo "#INFO Please click on \"Activities\" in the VNC."
        echo "(sleep 20 ; /usr/bin/xtigervncviewer :$LNUM ) &"
        (sleep 30 ; /usr/bin/xtigervncviewer :$LNUM ) &
    else  
        echo "#INFO Please install tiger VNC client and connect the vncviewer to $host:$LNUM"
        echo "#INFO And start SLURM GUI sview in VNC"
    fi
fi

echo ""
echo ""
