#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

if [ "$SPLAPP_BYPASS_EXE_WRAPPER" != "" ] ; then
    exec "$@"
fi
if [ "$SPLAPP_SRUN" != "" ]; then
    unset DIRENV_DIR DIRENV_DIFF DIRENV_WATCHES
    if [[ -f ".envrc" || -f ".env" ]]; then
        direnv allow . >& /dev/null
    fi
    eval "$(direnv hook bash 2>/dev/null)"
    eval "$(direnv export bash 2>/dev/null)"
fi

# set $PWD
cd . >& /dev/null

if [ "$SPILLBOX_MODULEPATH" != "" ] ; then
    export MODULEPATH=$SPILLBOX_MODULEPATH
fi
if [ "$SPILLBOX_TZ" != "" ] ; then
    export TZ=$SPILLBOX_TZ
fi
if [ "$LSF_DOCKERIZED_CLUSTER" == "true" ]; then
    if [ "$SPLAPP_STDOUT" != "" ] ; then
        export SPLAPP_STDOUT=`echo $SPLAPP_STDOUT | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    fi
    if [ "$SPLAPP_STDERR" != "" ] ; then
        export SPLAPP_STDERR=`echo $SPLAPP_STDERR | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    fi
fi
if [ "$SLURM_DOCKERIZED_CLUSTER" == "true" ]; then
    if [ "$SPLAPP_STDOUT" != "" ] ; then
        export SPLAPP_STDOUT=`echo $SPLAPP_STDOUT | sed s/%j/${SLURM_JOB_ID}/g | sed s/%A/${SLURM_ARRAY_JOB_ID}/g | sed s/%a/${SLURM_ARRAY_TASK_ID}/g`
    fi
    if [ "$SPLAPP_STDERR" != "" ] ; then
        export SPLAPP_STDERR=`echo $SPLAPP_STDERR | sed s/%j/${SLURM_JOB_ID}/g | sed s/%A/${SLURM_ARRAY_JOB_ID}/g | sed s/%a/${SLURM_ARRAY_TASK_ID}/g`
    fi
fi
if [[ "$SPLAPP_MULTI_CLUSTER" == "lsf" && "$SPILLBOX_BAPP" == "" ]]; then
    if [ "$SPILLBOX_WORKDIR" != "" ]; then
        if [ -d $SPILLBOX_WORKDIR ]; then
            cd $SPILLBOX_WORKDIR >& /dev/null
            export PWD=$SPILLBOX_WORKDIR
        fi
    fi
    if [ "$SPILLBOX_PATH" != "" ] ; then
        export PATH=$SPILLBOX_PATH
        hash -r
    fi
fi
if [ "${SPLAPP_SBATCH_DEFAULT_OUT}" != "" ]; then
    if [ -w $PWD ]; then
        SPLAPP_STDOUT="${PWD}/slurm-${SLURM_JOB_ID}.out"
    fi
fi
if [ "${SPLAPP_SBATCH_DEFAULT_ERR}" != "" ]; then
    if [ -w $PWD ]; then
        SPLAPP_STDERR="${PWD}/slurm-${SLURM_JOB_ID}.err"
    fi
fi
if [ "$SPILLBOX_BASH_FUNC" != "" ]; then
    local_SPILLBOX_BASH_FUNC=$(echo "${SPILLBOX_BASH_FUNC}" | sed 's/'-s_b-o_x-'/\n/g')
    eval "${local_SPILLBOX_BASH_FUNC}"
fi
if [[ "$LSF_DOCKERIZED_CLUSTER" == "true" && "$SPILLBOX_CR_JOBID" == "" ]]; then
    exec /bin/bash -c "$SPLAPP_USER_BIN_CMD"
fi
if [ "$SPLAPP_STDOUT" != "" ] ; then
    if [ "$SPLAPP_STDERR" != "" ] ; then
        # sequence of stdout and stderr is catured correctly in
        # 2>&1 when same file name is used
        if [ "$SPLAPP_STDERR" == "$SPLAPP_STDOUT" ] ; then
            if [[ ${#SPLAPP_USER_BIN_CMD} -eq 0 ]]; then
                exec /bin/bash -c "$@" > $SPLAPP_STDOUT 2>&1 
            else
                exec /bin/bash -c "$SPLAPP_USER_BIN_CMD" > $SPLAPP_STDOUT 2>&1 
            fi
        else
            if [[ ${#SPLAPP_USER_BIN_CMD} -eq 0 ]]; then
                exec /bin/bash -c "$@" > $SPLAPP_STDOUT  2> $SPLAPP_STDERR
            else
                exec /bin/bash -c "$SPLAPP_USER_BIN_CMD" > $SPLAPP_STDOUT  2> $SPLAPP_STDERR
            fi
        fi
    else
        if [[ ${#SPLAPP_USER_BIN_CMD} -eq 0 ]]; then
            exec /bin/bash -c "$@" > $SPLAPP_STDOUT
        else
            exec /bin/bash -c "$SPLAPP_USER_BIN_CMD" > $SPLAPP_STDOUT
        fi
    fi 
else 
    if [ "$SPLAPP_STDERR" != "" ] ; then
        if [[ ${#SPLAPP_USER_BIN_CMD} -eq 0 ]]; then
            exec /bin/bash -c "$@" 2> $SPLAPP_STDERR
        else
            exec /bin/bash -c "$SPLAPP_USER_BIN_CMD" 2> $SPLAPP_STDERR
        fi
    else
        if [[ ${#SPLAPP_USER_BIN_CMD} -eq 0 ]]; then
            exec /bin/bash -c "$@" 
        else
            exec /bin/bash -c "$SPLAPP_USER_BIN_CMD" 
        fi
    fi
fi
