#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )
export SPL_ROOT=$(realpath $DIR/../..)
spl_config_file=$(realpath ${SPL_ROOT}/terraform/etc/spillbox_config)
if [ -f  $spl_config_file ]; then
    . $spl_config_file
else
    echo missing config file : $spl_config_file >&2
    exit 3
fi

check_bapp_output=`which bapp 2>&1`
export RETVAL=$?
export check_bapp_output

if [ ${RETVAL} -ne 0 ] ; then
	echo [ERROR]: "LSF setup not sourced, 'bapp' not found in the PATH" 2>&1 | tee /dev/stderr
	echo "The error, Exit code : $RETVAL\n" 2>&1 | tee /dev/stderr
	echo $check_bapp_output 2>&1 | tee /dev/stderr
	printf "\n%s\n""Please source the LSF setup profile.lsf (for bash) or similar based on you shell type" 2>&1 | tee /dev/stderr
	exit 3
fi

export appname=$bapp_name
bapp_output=`bapp -l $appname 2>&1`
export RETVAL=$?
export bapp_ouput

if [ ${RETVAL} -ne 0 ] ; then
	echo "[ERROR]: LSF application profile $appname not setup correctly" 2>&1 | tee /dev/stderr
	printf "%s\n\n" "The error, Exit code : $RETVAL" 2>&1 | tee /dev/stderr
	echo $bapp_output 2>&1 | tee /dev/stderr
	echo "To setup bapp, please follow the instructions in doc/spillbox_lsf_docker_app_profile_configuration.docx" 2>&1 | tee /dev/stderr
	exit 3
fi


if [ " $bapp_output" == " " ]; then
	echo "[ERROR]: bapp cmd did not return any output neither did it exit with non zero status" 2>&1 | tee /dev/stderr
	printf "\n%s\n""Please run 'bapp -l splapp' on your terminal to debug" 2>&1 | tee /dev/stderr
	echo $bapp_output 2>&1 | tee /dev/stderr
	exit 3
fi

#APPLICATION NAME: dockerapp
#CONTAINER: docker[image(spillbox) options(--net=host --privileged -v /home/docuser/lafapp_work/splsep29/terraform/bin:/spillbox -v /cache_dir:/spillbox_workdir -v /usr/share/lsf:/usr/share/lsf -v /usr/local/lsf:/usr/local/lsf -e SPILLBOX_SITE --entrypoint /spillbox/bapp_entrypoint.sh)]
appre='APPLICATION NAME: '${appname}
contre='CONTAINER: docker.*:/spillbox'
entryre='--entrypoint '
netre='--net=host'
privre='--privileged'
#if [[ "$bapp_output" =~ $appre ]] && [[ "$bapp_output" =~ $contre ]] &&
#   [[ "$bapp_output" =~ $entryre ]] && [[ "$bapp_output" =~ $netre ]] &&
#   [[ "$bapp_output" =~ $privre ]] ; then
for i in $appre $contre $entryre $netre $privre; do
	if ! [[ "$bapp_output" =~ $i ]] ; then
		export err=1
		echo
		echo "'$i' The basic setup required for spillbox lsf application profile is missing"
fi
done

if [[ $err -ne 1 ]] ; then
	echo "The basic setup required for spillbox lsf application profile is present."
	exit 0
else
	exit 3
fi
