#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.
outarr=0
if [ "$SPLAPP_STDOUT" != "" ] ; then
    outsrc=`echo "%J_%I.out" | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    outdst=`echo $SPLAPP_STDOUT | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    outarr=$(echo "$SPLAPP_STDOUT" | egrep '%[I-J]' | wc -l )
fi
errarr=0
if [ "$SPLAPP_STDERR" != "" ] ; then
    errsrc=`echo "%J_%I.err" | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    errdst=`echo $SPLAPP_STDERR | sed s/%J/${LSB_JOBID}/g | sed s/%I/${LSB_JOBINDEX}/g`
    errarr=$(echo "$SPLAPP_STDERR" | egrep '%[I-J]' | wc -l )
fi
if [ "$SPILLBOX_WORKDIR" != "" ]; then
    if [ -d $SPILLBOX_WORKDIR ]; then
        cd $SPILLBOX_WORKDIR >& /dev/null
    fi
fi
LOGDIR="/spillbox_workdir/.spillbox/customers/${SPILLBOX_CLOUD_USER}/${SPILLBOX_PROJECT}-${SPILLBOX_SITE}/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/LSFLOG"
if [ "$SPLAPP_STDOUT" != "" ] ; then
    if [ -f "$LOGDIR/$outsrc" ]; then
        mv -f $LOGDIR/$outsrc $outdst
    fi
fi
if [ "$SPLAPP_STDERR" != "" ] ; then
    if [ -f "$LOGDIR/$errsrc" ]; then
        mv -f $LOGDIR/$errsrc $errdst
    fi
fi
if test $outarr -eq  1 ; then
   /bin/rm -f $SPLAPP_STDOUT 
fi
if test $errarr -eq  1 ; then
   /bin/rm -f $SPLAPP_STDERR 
fi
