#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

## This scripts needs the basic nc setup scripts sourced.
## And should have a vovenabled shell (vovproject enable....)

function docker_version_check () {
    docker_version=`$docker_path --version 2>&1`
    export RETVAL=$?
    if test $RETVAL -gt 0 ; then
        echo "[ERROR] : docker setup not available, please make sure docker setup is available" 2>&1 | tee /dev/stderr
        echo "$docker_version : $RETVAL" 2>&1 | tee /dev/stderr
        exit 3
    fi
    tarrVer=(${docker_version// / })
    arrVer=(${tarrVer[2]//./ })
    if [[ ${arrVer[0]} -eq 20 && ${arrVer[1]} -ge 10 ]] || 
       [[ ${arrVer[0]} -gt 20 ]] ; then
        echo "Recommended Docker version satisfied >=20.10"
    else
        echo "Recommended Docker version not satisfied"
        echo "Expected version : >=20.10"
        echo "Got : ${tarrVer[2]}"
        echo "Will continue with the image build, behavior might not be as desired"
    fi
}

function env_check() {
    c=0
    if [ "$nc_bapp_name" == "" ]; then
        echo "[ERROR]: Set a value to \"nc_bapp_name\" in $spl_config_file file"
        c+=1 
    fi
    if [ "$nc_vov_swd" == "" ]; then
        echo "[ERROR]: Set a value to \"nc_vov_swd\" in $spl_config_file file"
        c+=1 
    fi
    if [ "$nc_vov_project" == "" ]; then
        echo "[ERROR]: Set a value to \"nc_vov_project\" in $spl_config_file file"
        c+=1 
    fi
    if [ "$docker_path" == "" ]; then 
        docker_path=$(which docker)        
    fi
    if [ "$docker_path" == "" ]; then 
        echo "Please provide docker_path in $spl_config_file file"  >&2
        c+=1 
    fi
    if [ "$c" -ge 1 ]; then
        exit 1
    fi    
}

function nc_env_setup () {
    if [ -z "$NC_QUEUE" ] ; then
        echo "[ERROR]: NC_QUEUE is not exported, setting  NC_QUEUE to $nc_vov_project"
        echo "export NC_QUEUE=$nc_vov_project" 
    fi        

    if [ " ${VOV_PROJECT_NAME}" == " " ] ; then
        export VOV_PROJECT_NAME=$nc_vov_project
    fi
    #if [ ! -d $nc_vov_swd/$nc_vov_project/containers ] ; then
    #if [ ! -d containers ] ; then
    #    # Set the umask and the create the dir; it is secure
    #    # than creating dir and changing the permissions
    #    (umask 022 && mkdir containers;)
    #fi
}

function nc_docker_setup () {

    spl_nc_docker_setup_file=${nc_bapp_name}-setup.sh
    spl_nc_docker_enter_file=${nc_bapp_name}-enter.sh
    spl_nc_docker_cfg=${nc_bapp_name}.cfg
    spl_nc_tasker_file="taskers.tcl"

    # Create the nc hook file content locally
    # Check if WORKDIR is empty or unset
    if [ "$workdir" == "" ]; then
        workdir="$HOME"
    fi
   
    cat > $spl_nc_docker_setup_file << ELN
#!/bin/bash -f

containerName=\${VOV_PROJECT_NAME}_\${HOST}_\${VOV_CONTAINER_NAME}_\${VOV_JOBID}
envFile=/tmp/\$containerName.env
statusFile=/tmp/\$containerName.status
/bin/rm -f \$statusFile
if [ "\${SPILLBOX_DOCKER_IMAGE}" == "" ]; then
        echo "Env SPILLBOX_DOCKER_IMAGE not set" >&2
        exit 101
fi
if [ "\${SPLAPP_USER_CMD}" == "" ]; then
        echo "Env SPLAPP_USER_CMD not set" >&2
        exit 102
fi
if [ "\${SPILLBOX_DOCKER_PATH}" == "" ]; then
        echo "Env SPILLBOX_DOCKER_PATH not set" >&2
        exit 103
fi
if [ "\${SPILLBOX_TERRAFORMROOT}" == "" ]; then
        echo "Env SPILLBOX_TERRAFORMROOT not set" >&2
        exit 104
fi
if [ "\${SPILLBOX_WORKDIR}" == "" ]; then
        echo "Env SPILLBOX_WORKDIR not set" >&2
        exit 105
fi

export NC_DOCKERIZED_CLUSTER=true
env > \$envFile
/bin/chmod 666 \$envFile || /bin/true
/bin/chown \$SPILLBOX_CLOUD_USER \$envFile
if [ "\${SPILLBOX_CONTAINER_DEBUG}" != "1" ]; then
        rmstring="--rm "
fi
output=/tmp/\$containerName.output
/bin/touch \$output || /bin/true
/bin/chmod 666 \$output || /bin/true
interactive="-i"

(stdbuf -e0 -o0 \${SPILLBOX_DOCKER_PATH} run \${rmstring}--net=host --privileged \\
        -v \${SPILLBOX_TERRAFORMROOT}/bin:/spillbox \\
        -v ${workdir}:/spillbox_workdir \$SPILLBOX_DOCKER_VOLUME_LIST \\
        $LDAP_DIR \\
        \$SPILLBOX_DNS_SETUP \\
        --env-file=\$envFile \\
        --entrypoint=/spillbox/bapp_entrypoint.sh \\
        --name \$containerName \\
        \${interactive} \$SPILLBOX_DOCKER_IMAGE  "\$SPLAPP_USER_CMD" >> \$output 2>&1 ; echo \$? >\$statusFile ; /bin/chown \$SPILLBOX_CLOUD_USER \$statusFile \$output || /bin/true ) &

ELN

    cat > $spl_nc_docker_enter_file << ELN
#!/bin/bash -f
containerName=\${VOV_PROJECT_NAME}_\${HOST}_\${VOV_CONTAINER_NAME}_\${VOV_JOBID}
statusFile=/tmp/\${containerName}.status
envFile=/tmp/\${containerName}.env
output=/tmp/\${containerName}.output
PID=""
IPID=""

kill_job() {
    /bin/rm -f \${statusFile} || /bin/true
    /bin/rm -f \${envFile} || /bin/true
    if [ "\${PID}" != "" ]; then
        /bin/kill -9 \${PID} >& /dev/null || /bin/true
    fi
    if [ "\${IPID}" != "" ]; then
        /bin/kill -9 \${IPID} >& /dev/null || /bin/true
    fi
    nc stop \${NC_JOBID}
}

if [[ "\${SPLAPP_STDOUT}" == "" && "\${SPLAPP_INTERACTIVE_RUN}" == "" ]]; then
    if [ "\${NC_LOGDIR}" != "" ]; then
        if [ "\${*: -2:1}" == ">" ]; then
            ncsubdir=\`echo "\${@: -1}" | awk -F '/' '{print \$(NF-1)}'\`
            nclogname=\`echo "\${@: -1}" | awk -F '/' '{print \$NF}'\`
            /bin/mkdir -p \${NC_LOGDIR}/\${ncsubdir}
            LOGFILE=\${NC_LOGDIR}/\${ncsubdir}/\${nclogname}
        else
            if [ "\${NC_NOLOG}" != "" ]; then
                DATE=\$(date '+%Y%m%d')  
                LOGFILE=\${NC_LOGDIR}/\${DATE}/\${NC_NOLOG}
                /bin/mkdir -p \${NC_LOGDIR}/\${DATE}
            fi
        fi
    fi
fi

if [ "\${LOGFILE}" != "" ]; then
    /bin/touch \${LOGFILE}
    if [ "\${SPLAPP_NC_SHOWLOG}" != "" ]; then
        HOST=\$(hostname)
        echo "  <<<<STARTING ON \${HOST}>>>>" >> \${LOGFILE}
    fi
    /bin/tail -f  \${output} >> \${LOGFILE} &
    PID=\$!
fi

if [ "\${SPLAPP_INTERACTIVE_RUN}" != "" ]; then
    /bin/tail -f \${output} &
    IPID=\$!
fi

if [ "\${SPLAPP_INTERACTIVE_RUN}" != "" ]; then
    for signal in HUP INT QUIT ABRT KILL SEGV USR2 TERM ; do
        trap "kill_job" \${signal}
    done
fi

while [ ! -e \${statusFile} ]
do
  sleep 5
done

/bin/kill -9 \${PID} >& /dev/null || /bin/true
if [ "\${SPLAPP_INTERACTIVE_RUN}" != "" ]; then
    /bin/kill -9 \${IPID} >& /dev/null || /bin/true
fi
/bin/rm -f \${output} || /bin/true

RETVAL=\$(cat \${statusFile})
/bin/rm -f \${statusFile} || /bin/true
/bin/rm -f \${envFile} || /bin/true
if [[ "\${SPLAPP_NC_SHOWLOG}" != "" && "\${LOGFILE}" != "" ]]; then
   echo "   <<<<END OF LOG>>>>" >> \${LOGFILE}
   echo "   <<<<EXIT STATUS \${RETVAL}>>>>" >> \${LOGFILE}
fi

exit \${RETVAL}

ELN


    chmod 755 $spl_nc_docker_setup_file 
    export RETVAL=$?
    if test $RETVAL -ne 0 ; then
        echo "[ERROR]: Creation of $spl_nc_docker_setup_file failed with error code : $RETVAL" 2>&1 | tee /dev/stderr
        exit 3
    fi
    chmod 755 $spl_nc_docker_enter_file 
    if test $RETVAL -ne 0 ; then
        echo "[ERROR]: Creation of $spl_nc_docker_enter_file failed with error code : $RETVAL" 2>&1 | tee /dev/stderr
        exit 3
    fi
    echo
    echo "$PWD/$spl_nc_docker_setup_file file created, copy/append the required contents to the $nc_vov_swd/${nc_vov_project}.swd/containers/$spl_nc_docker_setup_file"
    echo "$PWD/$spl_nc_docker_enter_file file created, copy/append the required contents to the $nc_vov_swd/${nc_vov_project}.swd/containers/$spl_nc_docker_enter_file"
    echo "$nc_vov_swd/${nc_vov_project}.swd/containers/$spl_nc_docker_setup_file must be owned by root"
    echo "$nc_vov_swd/${nc_vov_project}.swd/containers/$spl_nc_docker_enter_file must be owned by root"

    vovsign_path=$(which vovsignfile)        
    if [ "$vovsign_path" == "" ]; then 
        echo "Could not find vovsignfile in $path"  >&2
        exit 1
    fi
    vovsign_setup=`$vovsign_path $spl_nc_docker_setup_file`
    vovsign_enter=`$vovsign_path $spl_nc_docker_enter_file`

        ### Example named-container configuration c1/c2 can be found in 
        ### <rtda installation directory>/common/etc/config/containers.
    # Create container config file 
    (umask 033; cat > $spl_nc_docker_cfg << ELN
## Hook run directory
#
# The default behavior is to switch to the job directory before running the
# hooks. If this directory is not accessible until the hooks have been executed
# though, the job will fail. This issue can be resolved by setting
# containerHooksRunDir to a location that is guaranteed to be accessible prior
# to the hooks being executed. This causes the subtasker to switch to that
# directory instead, and the original job directory will be made available to
# the hooks via the VOV_CONTAINER_JOB_RUNDIR environment variable. The value of
# this variable can then be used by the hooks to specify the working directory
# for the container instance.

# containerHooksRunDir "/path/to/run/directory"

## Hook definitions
#
# containerHook <type> <mode> <path> <signature>
#   <type>      = setup | enter | cleanup | teardown
#   <privilege> = user  | root
#   <file>      = absolute path to hook file
#   <signature> = output of vovsignfile command
#
# Specifies which hook(s) should be called to interact with the container
# platform throughout the job's life cycle:
#
# 1. The setup hook is required if the container must be created prior to
#    spawning the job. This hook will always be used if root privileges are
#    required to create containers.
# 2. The enter hook is always required and is responsible for placing the
#    job into the container. If root privileges are not required to create
#    containers and the container platform supports it, the enter hook can
#    also create the container, as would be done via the "docker run" command,
#    for example. The enter hook must block for the duration of the job.
# 3. The cleanup hook can be used to remove temporary artifacts that are
#    generated by the job.
# 4. The teardown hook is required to stop and/or remove the container. This
#    hook would normally be used if a setup hook is used to create the
#    container.
#
# Any root-mode hook must be owned by root on the filesystem.
#
# The tasker sets at least the HOST, nc_vov_project, VOV_JOBSLOT, and
# VOV_CONTAINER_NAME environment variables in the job execution environment.
# It is intended for the hooks to use these variables to uniquify container
# instances. Hooks can be tested by running them manually in the shell as long
# as the required environment variables are set to some value. The only hook
# that is called with arguments is the enter hook, which expects the job command
# line to be passed in. An example test run of the enter hook may look like:
#
# % env HOST=foo nc_vov_project=vnc VOV_JOBSLOT=0 VOV_CONTAINER_NAME=c2 \
# /path/to/c2-enter.sh whoami

#containerHook setup    root "/path/to/c2-setup.sh"    1211238920
containerHook setup    root "$nc_vov_swd/$nc_vov_project.swd/containers/$spl_nc_docker_setup_file" $vovsign_setup
containerHook enter    user "$nc_vov_swd/$nc_vov_project.swd/containers/$spl_nc_docker_enter_file" $vovsign_enter
#containerHook cleanup  user "/path/to/c2-cleanup.sh"  5376821904
#containerHook teardown root "/path/to/c2-teardown.sh" 8237156649

## Limit definitions
#
# containerLimit <CORES | RAM | TMP>
#
# Specifies which resources should be limited in the container. For each limit
# specified, the job's resource expression will be searched for a corresponding
# request. If found, the value of the request will be set as an environment
# variable in the execution environment so that the container hooks can use it.
# The environment variable will be in the form of:
#
# VOV_CONTAINER_<resource>

# containerLimit CORES
# containerLimit RAM
# containerLimit TMP
ELN
)
    if test $RETVAL -ne 0 ; then
        echo "[ERROR]: Creation of $spl_nc_docker_cfg failed with error code : $RETVAL" 2>&1 | tee /dev/stderr
        exit 3
    fi
    echo
    echo "$PWD/$spl_nc_docker_cfg file created, copy/append the required contents to the $nc_vov_swd/${nc_vov_project}.swd/containers/$spl_nc_docker_cfg"

    # Create  content 
    cat > $spl_nc_tasker_file << ELN
# The below has to be repeated or looped for each tasker/slave/host
# Slave is deprecated so use the term tasker, docs still contain slave
# at many places. 

    vtk_tasker_define localhost -resources "Container:${nc_bapp_name} @STD@"

# In Container:sbx_nc_dock_test "Container:" should be always be present
# for nc to invoke the proper docker resource script in the containers dir
# "sbx_nc_dock_test" is the resource name given by the admin (it can be any 
#other name too)

ELN
 
    if test $RETVAL -ne 0 ; then
        echo "[ERROR]: Creation of $spl_lsfshared_file failed with error code : $RETVAL"
        exit 3
    fi
    echo
    echo "$PWD/$spl_nc_tasker_file file created, copy/append the required contents to the $nc_vov_swd/${nc_vov_project}.swd/$spl_nc_tasker_file"

    echo
    echo "Please use these files as guidance and change as relevant to your environment"
    echo
    echo "Please run the command 'vovtaskermgr restart' to take effect of the changes"


} ### End of function

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )
export SPL_ROOT=$(realpath $DIR/../..)
spl_config_file=$(realpath ${SPL_ROOT}/terraform/etc/spillbox_config)
if [ -f  $spl_config_file ]; then
    . $spl_config_file
    export docker_host=`hostname -I | awk '{print $1}'`
     if [ "$docker_registry_port" == "" ]; then
        export docker_registry_port=5000
    fi
else
    echo missing config file : $spl_config_file >&2
    exit 3
fi

if [ "$setup_ldap" == "true" ]; then
    LDAP_DIR="-v /var/lib/sss/pipes:/var/lib/sss/pipes:rw"
else
    LDAP_DIR=""
fi

if [ "$setup_nis" == "true" ]; then
    NIS_DIR="-v /etc/nsswitch.conf:/etc/nsswitch.conf:ro -v /etc/yp.conf:/etc/yp.conf:ro"
else
    NIS_DIR=""
fi

env_check
docker_version_check
nc_env_setup
nc_docker_setup

