#!/bin/bash -f

func_handler() {
    raw_sig=$(kill -l $1)
    status=$?
    echo "$0: Recieved signal: $raw_sig($1), exit code: $status"
    ## Initimate docker firing script to self-immolate
    ## Any untrappable signal will not be passed to docker firing script
    echo "$raw_sig" > /tmp/${SLURM_JOB_ID}_killdock
    exit_status=$(($raw_sig + 128))
    #exit $exit_status
    #pgid=$(ps -o pgid= $$)
    #kill -15 $pgid
    #kill -15 $$
    # scancel sends TERM signal and scancel original exit status will be 0.
    # status CANCELLED is shown only if we exit with status 0.
    exit 0
}

for signal in HUP INT QUIT ABRT SEGV USR1 USR2 TERM ; do
	trap "func_handler ${signal}" ${signal}
done

if [ "$SPLAPP_USER_CMD" != "" ]; then
	echo "${SPLAPP_USER_CMD}" > /tmp/${SLURM_JOB_ID}_usrcmd
else
	echo "Env SPLAPP_USER_CMD not set" >&2
	echo "2" > /tmp/${SLURM_JOB_ID}_killdock
	exit 101
fi
if [ "$SPILLBOX_DOCKER_IMAGE" == "" ]; then
        echo "Env SPILLBOX_DOCKER_IMAGE not set" >&2
	echo "2" > /tmp/${SLURM_JOB_ID}_killdock
        exit 102
fi
#if [ "$SPILLBOX_DOCKER_PATH" == "" ]; then
#        echo "Env SPILLBOX_DOCKER_PATH not set" >&2
#	echo "2" > /tmp/${SLURM_JOB_ID}_killdock
#        exit 103
#fi
if [ "$SPILLBOX_TERRAFORMROOT" == "" ]; then
        echo "Env SPILLBOX_TERRAFORMROOT not set" >&2
	echo "2" > /tmp/${SLURM_JOB_ID}_killdock
        exit 104
fi
if [ "$SPILLBOX_WORKDIR" == "" ]; then
        echo "Env SPILLBOX_WORKDIR not set" >&2
	echo "2" > /tmp/${SLURM_JOB_ID}_killdock
        exit 105
fi

env > /tmp/${SLURM_JOB_ID}_fullenv
echo "$BASHPID" > /tmp/${SLURM_JOB_ID}_waitjobpid

SRUN_TAILSET=0
enter_pid=`cat /tmp/${SLURM_JOB_ID}_enterpid`
while [ ! -f /tmp/${SLURM_JOB_ID}_status ]
do
	if [[ "$SPLAPP_SRUN"  == "1" && -f /tmp/${SLURM_JOB_ID}_output && $SRUN_TAILSET -eq 0 ]]; then
		tail -f /tmp/${SLURM_JOB_ID}_output &
		OUT_PID=$!
		SRUN_TAILSET=1
	fi
	ret=$(ps aux | grep -w  $enter_pid | grep -v grep)
	if [[ ${#ret} -eq 0  && ! -f /tmp/${SLURM_JOB_ID}_status ]]; then
		echo Enter script has exited abrubtly... so exiting... 2>&1 | tee /dev/stderr
		exit 1
	fi
	sleep 1
done
if [[ $SRUN_TAILSET -eq 0 && -f /tmp/${SLURM_JOB_ID}_output ]]; then
    cat /tmp/${SLURM_JOB_ID}_output
fi
if [[ "$SPLAPP_SRUN"  == "1" ]]; then
    {/bin/kill -9 ${OUT_PID}} > /dev/null 2>&1
fi

exit_status=`cat /tmp/${SLURM_JOB_ID}_status`
/bin/rm -rf /tmp/${SLURM_JOB_ID}_status >& /dev/null || /bin/true
exit $exit_status


