#!/bin/bash -f
func_handler() {
    raw_sig=$?
    sig=$(($raw_sig - 128))
    echo "$0: Recieved signal $sig"
    echo "signal_recieved" > /tmp/signalinfo
    ## Initimate docker firing script to self-immolate
    ## Any untrappable signal will not be passed to docker firing script
    if [ -f /tmp/${SLURM_JOB_ID}_dockbgpid ]; then
        dockbgpid=$(cat /tmp/${SLURM_JOB_ID}_dockbgpid)
    fi
    kill_descendant_processes $dockbgpid true
    clean_tmp
    kill -9 $$
    exit 0
}
kill_descendant_processes() {
    local pid="$1"
    local and_self="${2}"
    if children="$(pgrep -P "$pid")"; then
           for child in $children; do
               kill_descendant_processes "$child" false
           done
       fi
    if [ "$and_self" == "true" ] ; then
        docker rm -f ${SLURM_JOB_ID}.slurmjob
    fi
    /bin/rm -rf /tmp/${SLURM_JOB_ID}_status
    sudo kill -9 $pid

}
clean_tmp() {
    sudo rm -f /tmp/${SLURM_JOB_ID}_usrcmd
    sudo rm -f /tmp/${SLURM_JOB_ID}_usrfunc
    sudo rm -f /tmp/${SLURM_JOB_ID}_fullenv
    sudo rm -f /tmp/${SLURM_JOB_ID}_enterpid
    sudo rm -f /tmp/${SLURM_JOB_ID}_waitjobpid
    sudo rm -f /tmp/${SLURM_JOB_ID}_killdock
    sudo rm -f /tmp/${SLURM_JOB_ID}_dockbgpid
    sudo rm -f /tmp/${SLURM_JOB_ID}_output
    if [ "$SPILLBOX_CONTAINER_DEBUG" == "" ]; then
        sudo rm -f /tmp/${SLURM_JOB_ID}_prolog
    fi
}

is_service_running() {
    service_name="$1"

    if output=$(sudo systemctl is-active "$service_name" 2>/dev/null); then
        if [ "$output" == "active" ]; then
            return 0  # true
        else
            return 1  # false
        fi
    else
        echo "Failed to check status of $service_name"
        return 1  # false
    fi
}

start_service() {
    service_name="$1"
    if [ "$service_name" == "cachefilesd" ]; then
        if [ ! -x /sbin/cachefilesd ]; then
            APT="apt-get"
            OSID=$(cat /etc/os-release | grep ^ID= | awk -F= '{print $2}' | sed 's/"//g')
            if [[ $OSID == "centos" ]] || [[ "$OSID" == "rhel" ]] || [[ "$OSID" == "rocky" ]] || [[ "$OSID" == "amzn" ]]; then
                APT="yum"
            fi
            sudo $APT install -y cachefilesd
        fi
        spillbox_cache_dir="${SPILLBOX_BOOST_CLIENT_CACHE_DIR:-/var/cache/fscache/}"
        full_path="$spillbox_cache_dir/spillbox_cache"

        # Create directory
        if ! sudo mkdir -p "$full_path"; then
            echo "Failed to create directory $full_path"
            return 1
        fi

        # Create temporary config file
        config_file="/tmp/cachefilesd.conf"
        start_file="/tmp/cachefilesd"
        {
            flock 200
            cat <<EOF > "$config_file"
dir $spillbox_cache_dir/spillbox_cache
brun 10%
bcull 7%
bstop 3%
frun 10%
fcull 7%
fstop 3%
#secctx system_u:system_r:cachefiles_kernel_t:s0
EOF
            cat <<EOF > "$start_file"
RUN=yes
DAEMON_OPTS=""
EOF
        } 200>"$config_file.lock"

        # Copy config to system directory
        sudo cp -f "$config_file" /etc/cachefilesd.conf || true
        sudo cp -f "$start_file" /etc/default/cachefilesd || true
        sudo chmod 644 /etc/cachefilesd.conf /etc/default/cachefilesd || {
            echo "Failed to update configuration file permissions"
            return 1
        }

        # Disable SELinux enforcement temporarily
        sudo setenforce 0 || true

        if [ -x /sbin/cachefilesd ]; then
           # RAND="/spillbox_client_cache$$"
           # $sudocmd mkdir -p $RAND /var/cache/fscache 
           # $sudocmd mount -t ramfs ramfs $RAND
           # $sudocmd truncate -s $SPILLBOX_BOOST_CLIENT_CACHE_SIZE $RAND/ramdisk.img
           # yes | $sudocmd mkfs.ext4 $RAND/ramdisk.img >& /dev/null
           # $sudocmd mount $RAND/ramdisk.img /var/cache/fscache
            if [ -x "$MODPROBE" ]; then
                if ! /sbin/lsmod | grep cachefiles > /dev/null ; then
                    $sudocmd $MODPROBE cachefiles
                    RETVAL=$?
                    if test ${RETVAL} -ne 0 ; then
                        mod=$(find /usr/lib/modules/ -name cachefiles.ko.xz 2>/dev/null)
                        $sudocmd insmod $mod
                        RETVAL=$?
                        if test ${RETVAL} -ne 0 ; then
                            echo "Failed to load fscache module, status ${RETVAL}" >&2
                        fi
                    fi
                fi
            fi
            if [ ! -c /dev/cachefiles ]; then
                $sudocmd mknod /dev/cachefiles c 10 56
                RETVAL=$? 
                if test ${RETVAL} -ne 0 ; then
                    echo "mknod failed with status $RETVAL" >&2
                fi
            fi
            # Start the service
            if ! sudo systemctl restart "$service_name"; then
                echo "Failed to start $service_name"
                return 1
            fi
        else
            echo "missing /sbin/cachefilesd" >&2 
        fi
    fi
}

DC=""
SPILLBOX_DNS_SETUP=""
RESOLV="/etc/resolv.conf"
MODPROBE=/sbin/modprobe

if [ "$1" == "triggerdocker" ]; then
    for signal in HUP INT QUIT ABRT SEGV USR2 TERM ; do
          trap "func_handler" ${signal}
    done
(
    echo $BASHPID > /tmp/${SLURM_JOB_ID}_enterpid
    timeout=30
    count=0
    while [ $count -lt $timeout ] ; do
            if [ -f "/tmp/${SLURM_JOB_ID}_waitjobpid" ] ; then
                    break
            fi
            if [ -f "/tmp/${SLURM_JOB_ID}_killdock" ]; then
                    exit
            fi
            ((count+=2))
            sleep 2
    done
    if  [ -f /tmp/${SLURM_JOB_ID}_waitjobpid ] ; then
            waitjob_pid=`cat /tmp/${SLURM_JOB_ID}_waitjobpid`
    else
            sudo rm -f /tmp/${SLURM_JOB_ID}_enterpid
            sudo rm -f /tmp/${SLURM_JOB_ID}_prolog
            exit 0
    fi

    ## restrict this to 30secs?? might be have a configurable value
    while [ ! -e "/tmp/${SLURM_JOB_ID}_usrcmd" ]
    do
        sleep 2
        if [ -f "/tmp/${SLURM_JOB_ID}_killdock" ]; then
            exit
        else
            kill -0 $waitjob_pid
            ret=$?
            if [ "$ret" != "0" ]; then
                echo "waitjob_pid has exited, so exiting...."
                exit
            fi
        fi
    done
    export user_cmd=`cat /tmp/${SLURM_JOB_ID}_usrcmd`
    #SPILLBOX_DOCKER_IMAGE
    SPILLBOX_DOCKER_IMAGE=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_DOCKER_IMAGE |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_TERRAFORMROOT=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_TERRAFORMROOT |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_DIR=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_TERRAFORMROOT |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g' | awk -F "/.spillbox" '{print $1}')
    SPILLBOX_CONTAINER_DEBUG=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_CONTAINER_DEBUG |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_RUN_DETACHED=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_RUN_DETACHED |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_VNC=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_VNC |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_CLOUD_PASSWORD=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_CLOUD_PASSWORD |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_DOCKER_PATH=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_DOCKER_PATH |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_CLOUD_USER=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_CLOUD_USER |  awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_DOCKER_VOLUME_LIST=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_DOCKER_VOLUME_LIST |  awk -F'SPILLBOX_DOCKER_VOLUME_LIST=' '{print $2}' | sed -e 's/^"//' -e 's/"$//' )
    LDAP_DIR=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^LDAP_DIR |  awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' )
    NIS_DIR=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^NIS_DIR |  awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//')
    SPILLBOX_BOOSTMODE=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_BOOSTMODE |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    SPILLBOX_BOOST_CLIENT_CACHE_DIR=$(cat /tmp/${SLURM_JOB_ID}_fullenv | grep ^SPILLBOX_BOOST_CLIENT_CACHE_DIR |   awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
    if [ "$SPILLBOX_BOOSTMODE" != "" ]; then
        service_name="cachefilesd"
        {
            if flock -n 400; then
                if ! is_service_running "$service_name"; then
                    start_service "$service_name"
                fi
            fi
        } 400>"/tmp/$service_name.lock"
        if [ "$SPILLBOX_BOOST_CLIENT_CACHE_DIR" != "" ]; then
            export SPILLBOX_DOCKER_VOLUME_LIST="$SPILLBOX_DOCKER_VOLUME_LIST -v $SPILLBOX_BOOST_CLIENT_CACHE_DIR:$SPILLBOX_BOOST_CLIENT_CACHE_DIR"
        fi
    fi
    if [ "$SPILLBOX_DOCKER_PATH" == "" ]; then
        DOCKER_PATH="docker"
    else
        DOCKER_PATH=$SPILLBOX_DOCKER_PATH
    fi
    if [ "$SPILLBOX_CONTAINER_DEBUG" == "" ]; then
        DC+=" --rm"
    fi
    if [ "$SPILLBOX_RUN_DETACHED" != "" ] ; then
            DC+=" --detach "  
    fi
    if [ "$SPILLBOX_VNC" != "" ] ; then
            DC+=" -p 3389 --shm-size=1g --volume /run/dbus:/run/dbus --volume /sys/fs/cgroup:/sys/fs/cgroup -it "  
    else
            DC+=" --net=host "  
    fi

    if [ -f "$RESOLV" ]; then
        while IFS="" read -r p || [ -n "$p" ]
        do
            d=$(echo $p | grep ^nameserver | awk '{print $2}')
            if [ "$d" != "" ]; then
                SPILLBOX_DNS_SETUP="$SPILLBOX_DNS_SETUP --dns=$d"
            fi
            d=$(echo $p | grep ^search | awk '{$1=""; print $0}')
            if [ "$d" != "" ]; then
                for i in $d
                do
                    SPILLBOX_DNS_SETUP="$SPILLBOX_DNS_SETUP --dns-search=$i"
                done
            fi
        done < $RESOLV
    fi
    export SPILLBOX_DNS_SETUP=$SPILLBOX_DNS_SETUP
    export SPILLBOX_VNC=$SPILLBOX_VNC
    export SPILLBOX_CLOUD_PASSWORD=$SPILLBOX_CLOUD_PASSWORD

    # Image spillbox has to be ip addr:spillbox
    if [ "$SPILLBOX_RUN_DETACHED" != "" ] ; then
        set -x
        ID=$( stdbuf -e0 -o0 $DOCKER_PATH run $SPILLBOX_DNS_SETUP --privileged $DC -v ${SPILLBOX_TERRAFORMROOT}/bin:/spillbox -v $SPILLBOX_DIR:/spillbox_workdir $LDAP_DIR $NIS_DIR $SPILLBOX_DOCKER_VOLUME_LIST --env-file=/tmp/${SLURM_JOB_ID}_fullenv --name ${SLURM_JOB_ID}.slurmjob --entrypoint /spillbox/bapp_entrypoint.sh $SPILLBOX_DOCKER_IMAGE "${user_cmd}")
        dock_exit_status=$? ;
        host=$(hostname -f)
        port=$($DOCKER_PATH port $ID | awk '{print $3}' | awk -F: '{print $2}')
        echo "Remote Desktop Server : $host:$port" >> /tmp/${SLURM_JOB_ID}_output
        sleep 5
        echo $dock_exit_status > /tmp/${SLURM_JOB_ID}_status
        chmod 777 /tmp/${SLURM_JOB_ID}_status
    else
        ( stdbuf -e0 -o0 $DOCKER_PATH run $SPILLBOX_DNS_SETUP --privileged $DC -v ${SPILLBOX_TERRAFORMROOT}/bin:/spillbox -v $SPILLBOX_DIR:/spillbox_workdir $LDAP_DIR $NIS_DIR $SPILLBOX_DOCKER_VOLUME_LIST --env-file=/tmp/${SLURM_JOB_ID}_fullenv --name ${SLURM_JOB_ID}.slurmjob --entrypoint /spillbox/bapp_entrypoint.sh $SPILLBOX_DOCKER_IMAGE "${user_cmd}" >> /tmp/${SLURM_JOB_ID}_output 2>&1;
        dock_exit_status=$? ;
        echo $dock_exit_status > /tmp/${SLURM_JOB_ID}_status
        chmod 777 /tmp/${SLURM_JOB_ID}_status
        )&
        dock_bg_pid=$!
        echo $dock_bg_pid > /tmp/${SLURM_JOB_ID}_dockbgpid
        while [ 1 ]
        do    
            sleep 1
            if [ -f "/tmp/${SLURM_JOB_ID}_killdock" ]; then
                if [ -f /tmp/${SLURM_JOB_ID}_dockbgpid ]; then
                       dockbgpid=$(cat /tmp/${SLURM_JOB_ID}_dockbgpid)
                   fi
                kill_descendant_processes $dockbgpid true
                break
            else
                kill -0 $waitjob_pid
                ret=$?
                if [ "$ret" != "0" ]; then
                    echo "waitjob_pid has exited, so exiting...."
                    kill -9 $dock_bg_pid
                    break
                else
                    kill -0 $dock_bg_pid
                    ret=$?
                    if [ "$ret" != "0" ]; then
                        break
                    fi
                fi
            fi
        done
    fi
    clean_tmp
)& 
exit 0
fi

(
setsid $0 triggerdocker
) &> /tmp/${SLURM_JOB_ID}_prolog
exit 0

