#!/bin/bash -f

# Copyright © 2018-2025, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

if [ $# -ne 3 ]; then
  echo "Usage: $0 <user> <project> <docker_path>" >&2
  exit 1
fi

user="$1"
project="$2"
docker_path="$3"

found=0

echo "Remote Desktop Server : "
for container_id in $($docker_path ps -q); do
  inspect=$($docker_path inspect "$container_id" 2>/dev/null)

  dock_user=$(echo "$inspect" | grep -i "SPILLBOX_CLOUD_USER" | awk -F '=' '{print $2}' | awk -F '"' '{print $1}')
  dock_project=$(echo "$inspect" | grep -i "SPILLBOX_PROJECT" | awk -F '=' '{print $2}' | awk -F '"' '{print $1}')

  if [ "$dock_user" == "$user" ] && [ "$dock_project" == "$project" ]; then
    ip=$($docker_path inspect --format '{{.Config.Image}}' "$container_id" | awk -F: '{print $1}')
#    name=$($docker_path inspect --format '{{.Name}}' "$container_id" | sed 's/^\/\?//')
#    image=$($docker_path inspect --format '{{.Config.Image}}' "$container_id")
    vnc_port=$($docker_path inspect --format '{{range $p, $conf := .NetworkSettings.Ports}}{{if eq $p "3389/tcp"}}{{(index $conf 0).HostPort}}{{end}}{{end}}' "$container_id")
    echo "$ip:$vnc_port"
    found=1
  fi
done

if [ "$found" -eq 0 ]; then
  echo "No container found for user='$user' and project='$project'"
fi
