terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.89.0"
    }
    null = {
      version = "3.2.3"
    }
    template = {
      version = "2.2.0"
    }
  }
  backend "s3" {
    key     = "states/webserver"
    encrypt = true
  }
}

provider "aws" {
  region = var.region
}
locals {
  key_name = "${var.imagetag}-auto-key"
  private_key_filename = format("%s/%s.pem", var.secrets, local.key_name)
}

resource "aws_instance" "compute" {
  instance_type          = var.webserver_instance_type
  ami                    = var.ami_name
  key_name               = var.keyname
  vpc_security_group_ids = [var.security_group_id]
  subnet_id              = var.subnet_id
  associate_public_ip_address = var.spillbox_private_cloud == "true" ? false : true
 tags = {
    Name = "Spillbox-Webserver-${var.imagetag}"
  }
 user_data = data.template_cloudinit_config.config.rendered

  root_block_device {
    volume_size           = var.webserver_root_volume_size
    kms_key_id            = var.kms_key_id == "" ? null : var.kms_key_id
    encrypted             = var.kms_key_id == "" ? false : true
    delete_on_termination = true
  }

  provisioner "local-exec" {
    command = "sleep ${var.wait_time_vm} && echo done waiting master VM ready"
  }
}

resource "null_resource" "webserver_install" {
  connection {
    user        = var.vm_user
    private_key = file(local.private_key_filename)
    host        = aws_instance.compute.private_ip
    port        = 22
    timeout     = "600s"
  }
  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; /tmp/install/install.sh 'true' '${var.cluster_create}' ${var.vm_user} '/tmp/install' '${var.docker_registry}' '${var.docker_images}' '${var.service_userid}' '${var.os_type_ami}' '${var.pcluster_version}'"]
  }
}
