locals {
  webserver_host = var.enable_sgo == "false" ? var.webserver[0] : element(flatten(var.master_private_ip), 0)
}

resource "null_resource" "webserver" {
  count = var.webserver_create == "true" ? 1 : 0
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = local.webserver_host
    port        = var.cloud_ssh_port
  }

  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pem"
    destination = "/tmp/key.pem"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pub"
    destination = "/tmp/key.pub"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh '${var.cloud_provider}' webserver '${var.dnsname}' '${var.mountname}' '${local.master_ip}' '${var.vm_user}' '${var.singularity_sifpath}'"]
  }
}

resource "null_resource" "webserver_destroy" {
  count = var.webserver_create == "true" ? 1 : 0

  triggers = {
    host        = local.webserver_host
    user        = var.vm_user
    private_key = file(var.private_key)
    port        = var.cloud_ssh_port
  }

  provisioner "remote-exec" {
    when = destroy

    connection {
      host        = self.triggers.host
      user        = self.triggers.user
      private_key = self.triggers.private_key
      port        = self.triggers.port
    }

    inline = ["sudo chmod 755  /tmp/install/node_destroy.sh; /tmp/install/node_destroy.sh","sudo chmod 755 /tmp/install/uninstall.sh; sudo /tmp/install/uninstall.sh"]
  }
}

resource "null_resource" "webserver_singularity_sif" {
  count = var.spillbox_container == "singularity" ? 1 : 0
  provisioner "file" {
    source      = "${var.singularity_sifpath}"
    destination = "/spillbox_sif/${basename(var.singularity_sifpath)}"
  }
}

resource "null_resource" "webserver_local" {
  count = var.webserver_create == "false" ? 1 : 0

  provisioner "local-exec" {
    command = "sudo cp ${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pem /tmp/key.pem; sudo chown ${var.customer}:${var.customer} /tmp/key.pem"
  }

  provisioner "local-exec" {
    command = "sudo cp ${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pub /tmp/key.pub; sudo chown ${var.customer}:${var.customer} /tmp/key.pub"
  }

  provisioner "local-exec" {
    command = "sudo cp -r ${path.module}/install /tmp/"
  }

  provisioner "local-exec" {
    command = "sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh '${var.cloud_provider}' webserver '${var.dnsname}' '${var.mountname}' '${local.master_ip}' '${var.vm_user}' '${var.singularity_sifpath}'"
  }
}

resource "null_resource" "webserver_local_destroy" {
  count = var.webserver_create == "false" ? 1 : 0

  provisioner "local-exec" {
    when    = destroy
    command = "sudo chmod 755 /tmp/install/uninstall.sh; sudo /tmp/install/uninstall.sh"
  }
}

resource "null_resource" "webserver_local_singularity_sif" {
  count = var.spillbox_container == "singularity" ? 1 : 0
  provisioner "local-exec" {
    command = "sudo cp -r ${var.singularity_sifpath} /spillbox_sif/${basename(var.singularity_sifpath)}"
  }
}


resource "null_resource" "compute" {
  depends_on = [null_resource.webserver_local, null_resource.webserver]
  count      = var.enable_sgo == "false" ? length(var.compute) : var.min_compute_number
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = var.enable_sgo == "false" ? element(flatten(var.compute[*]), count.index) : element(flatten(var.worker_private_ip), count.index)
    port        = var.cloud_ssh_port
  }

  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pem"
    destination = "/tmp/key.pem"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pub"
    destination = "/tmp/key.pub"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh '${var.cloud_provider}' 'compute' '${var.dnsname}' '${var.mountname}' '${local.master_ip}' '${var.vm_user}' '${var.singularity_sifpath}'"]
  }
}

resource "null_resource" "nfs" {
  depends_on = ["null_resource.compute"]
  count      = var.enable_sgo == "false" ? length(var.nfs) : var.min_nfs_number
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = var.enable_sgo == "false" ? element(flatten(var.nfs[*]), count.index) : element(flatten(var.splfs_private_ip), count.index)
    port        = var.cloud_ssh_port
  }

  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pem"
    destination = "/tmp/key.pem"
  }
  provisioner "file" {
    source      = "${path.module}/../../../.ssh/${var.cloud_provider}/${var.customer}-${var.servername}/${var.customer}-${var.servername}-auto-key.pub"
    destination = "/tmp/key.pub"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh '${var.cloud_provider}' 'nfs' '${var.dnsname}' '${var.mountname}' '${local.master_ip}' '${var.vm_user}' '${var.singularity_sifpath}'"]
  }
}

locals {
  master_ip   = var.enable_sgo == "false" ? var.webserver[0] : var.webserver_create == "true" ? element(flatten(var.master_private_ip), 0) : var.webserver[0]
  compute_ips = var.enable_sgo == "false" ? "${join(",", flatten(var.compute[*]))}" : "${join(",", flatten(var.worker_private_ip))}"
  nfs_ips     = var.enable_sgo == "false" ? "${join(",", flatten(var.nfs[*]))}" : "${join(",", flatten(var.splfs_private_ip))}"
  subnet_id   = element(flatten(var.subnetid), 0)
  sg_id       = element(flatten(var.securitygroupid), 0)
}

resource "null_resource" "lsf_master" {
  count      = var.enable_lsfinstall == "true" && var.webserver_create == "true" ? 1 : 0
  depends_on = [null_resource.webserver, null_resource.compute, null_resource.nfs]
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = var.enable_sgo == "false" ? var.webserver[0] : element(flatten(var.master_private_ip), 0)
    port        = var.cloud_ssh_port
  }

  provisioner "file" {
    source      = "${path.module}/scripts/lsfinstall.tar.gz"
    destination = "/fsx_shared/lsfinstall.tar.gz"
  }

  provisioner "remote-exec" {
    inline = ["cd /fsx_shared ; curl -O https://s3.us-west-1.amazonaws.com/spillbox.io-internal/lsf_tarfiles.tar.gz ; tar xvf lsf_tarfiles.tar.gz "]
  }

  provisioner "remote-exec" {
    inline = ["cd /fsx_shared ; tar xvf lsfinstall.tar.gz  ;  /fsx_shared/Install_Scripts/substitute.sh '${var.cloud_provider}' '${local.subnet_id}' '${local.sg_id}' '${var.project}' '${var.vpcid}' '${var.dnsname}' '${var.mountname}' '${var.customer}' '${var.servername}' '${var.region}' '${var.nfsami_id}' '${var.computeami_id}' '${var.vm_user}' '${var.keyname}' '${var.zone}' '${var.compartment_ocid}' '${var.subnet_dns}' '${var.spillbox_container}'; sudo /fsx_shared/Install_Scripts/substitute.sh sgo '${local.master_ip}' '${local.compute_ips}' '${local.nfs_ips}' '${var.vm_user}' '${var.min_compute_number}' '${var.max_compute_number}' '${var.min_nfs_number}' '${var.max_nfs_number}' '${var.nfs_instance_type}' '${var.compute_instance_type}' '${var.max_spot_count}' '${var.max_spot_price}' '${var.spot_instance_type}' '${var.spot_allocation_strategy}' '${var.cloud_provider}' '${var.spot_role}' '${var.spot_tag}' '${var.compute_tag}' '${var.nfs_tag}' '${var.iam_instance_profile}' '${var.spillbox_container}' '${var.service_userid}' '${var.nfs_cpu}' '${var.nfs_mem}' '${var.compute_cpu}' '${var.compute_mem}' '${var.spot_cpu}' '${var.spot_mem}'; sudo /fsx_shared/Install_Scripts/spillbox_autolsfsetup.sh iconfig rcconfig"]
  }
}

resource "null_resource" "lsf_master_local" {
  count      = var.enable_lsfinstall == "true" && var.webserver_create == "false" ? 1 : 0
  depends_on = [null_resource.webserver_local, null_resource.compute, null_resource.nfs]

  provisioner "local-exec" {
    command = "sudo cp -r ${path.module}/scripts/lsfinstall.tar.gz /fsx_shared/lsfinstall.tar.gz"
  }

  provisioner "local-exec" {
    command = "cd /fsx_shared ; curl -O https://s3.us-west-1.amazonaws.com/spillbox.io-internal/lsf_tarfiles.tar.gz ; tar xvf lsf_tarfiles.tar.gz "
  }

  provisioner "local-exec" {
    command = "cd /fsx_shared ; tar xvf lsfinstall.tar.gz ; /fsx_shared/Install_Scripts/substitute.sh '${var.cloud_provider}' '${local.subnet_id}' '${local.sg_id}' '${var.project}' '${var.vpcid}' '${var.dnsname}' '${var.mountname}' '${var.customer}' '${var.servername}' '${var.region}' '${var.nfsami_id}' '${var.computeami_id}' '${var.vm_user}' '${var.keyname}' '${var.zone}' '${var.compartment_ocid}' '${var.subnet_dns}' '${var.spillbox_container}'; sudo /fsx_shared/Install_Scripts/substitute.sh sgo '${local.master_ip}' '${local.compute_ips}' '${local.nfs_ips}' '${var.vm_user}' '${var.min_compute_number}' '${var.max_compute_number}' '${var.min_nfs_number}' '${var.max_nfs_number}' '${var.nfs_instance_type}' '${var.compute_instance_type}' '${var.max_spot_count}' '${var.max_spot_price}' '${var.spot_instance_type}' '${var.spot_allocation_strategy}' '${var.cloud_provider}' '${var.spot_role}' '${var.spot_tag}' '${var.compute_tag}' '${var.nfs_tag}' '${var.iam_instance_profile}' '${var.spillbox_container}' '${var.service_userid}' '${var.nfs_cpu}' '${var.nfs_mem}' '${var.compute_cpu}' '${var.compute_mem}' '${var.spot_cpu}' '${var.spot_mem}'; sudo /fsx_shared/Install_Scripts/spillbox_autolsfsetup.sh iconfig rcconfig"
  }
}


resource "null_resource" "spillbox_webserver" {
  count      = var.webserver_create == "true" ? 1 : 0
  depends_on = [null_resource.lsf_master]
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = var.enable_sgo == "false" ? var.webserver[0] : element(flatten(var.master_private_ip), 0)
    port        = var.cloud_ssh_port
  }

  provisioner "file" {
    source      = "${path.module}/../../../config"
    destination = "/tmp/config"
  }
  provisioner "file" {
    source      = "${path.module}/scripts/Install_Scripts/build_server.sh"
    destination = "/tmp/build_server.sh"
  }

  provisioner "remote-exec" {
    inline = [" sudo chmod 777 /tmp/build_server.sh ; /tmp/build_server.sh hostname /tmp/config/spillbox_config spillbox '${var.vm_user}' '${var.spillbox_container}' '${var.singularity_sifpath}' '${var.service_userid}' '${var.nfs_cpu_limit}'"]
  }
}

resource "null_resource" "spillbox_webserver_local" {
  count      = var.webserver_create == "false" ? 1 : 0
  depends_on = [null_resource.lsf_master_local]

  provisioner "local-exec" {
    command = "sudo cp -r ${path.module}/../../../config /tmp/config; sudo cp -r ${path.module}/scripts/Install_Scripts/build_server.sh /tmp/build_server.sh "
  }
  provisioner "local-exec" {
    command = "sudo chmod 777 /tmp/build_server.sh ; /tmp/build_server.sh hostname /tmp/config/spillbox_config spillbox '${var.vm_user}' '${var.spillbox_container}' '${var.singularity_sifpath}' '${var.service_userid}' '${var.nfs_cpu_limit}'"
  }
}
