#!/bin/sh -fx

logfile=/tmp/user_data.log
echo START `date '+%Y-%m-%d %H:%M:%S'` >> $logfile

#
# Export user data, which is defined with the "UserData" attribute 
# in the template
#
%EXPORT_USER_DATA%

#
# Add your customization script here
#

#
# Source LSF enviornment at the VM host
#
LSF_TOP=/sbox_lsf/lsf
LSF_CONF_FILE=$LSF_TOP/conf/lsf.conf
. $LSF_TOP/conf/profile.lsf
env >> $logfile

# 
# Support rc_account resource to enable RC_ACCOUNT policy  
# Add additional local resources if needed 
#
echo "rc account arrived is :: $rc_account" >> $logfile
                                   
cat $LSF_CONF_FILE >> $logfile

if [ "${rc_account}" == "rc_nfs" ]; then
    echo "NFS instance detected. Running additional setup script..." >> $logfile
    sed -i "s/awshost/awshost1/" $LSF_CONF_FILE
elif [ "${rc_account}" == "rc_spot" ]; then
    sed -i "s/awshost/awshost2/" $LSF_CONF_FILE
fi

if [ -n "${rc_account}" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap ${rc_account}*rc_account]\"/" $LSF_CONF_FILE
echo "update LSF_LOCAL_RESOURCES lsf.conf successfully, add [resourcemap ${rc_account}*rc_account]" >> $logfile
fi
sed -i "s/^LSF_SERVER_HOSTS/#LSF_SERVER_HOSTS/g" $LSF_CONF_FILE

#
# Include origin information for fault tolerance
#
instance_id=$(curl http://169.254.169.254/latest/meta-data/instance-id)
if [ -n "$instance_id" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap $instance_id*instanceID]\"/" $LSF_CONF_FILE
fi
vm_type=$(curl http://169.254.169.254/latest/meta-data/instance-type)
if [ -n "$vm_type" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap $vm_type*vm_type]\"/" $LSF_CONF_FILE
fi
if [ -n "$template_id" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap $template_id*templateID]\"/" $LSF_CONF_FILE
fi
if [ -n "$clustername" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap $clustername*clusterName]\"/" $LSF_CONF_FILE
fi
if [ -n "$providerName" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap $providerName*providerName]\"/" $LSF_CONF_FILE
fi

#
# Run lsreghost command to register the host to LSF master if no DNS update
#
#echo "lsfdev1.test.com" > $LSF_ENVDIR/hostregsetup
#lsreghost -s $LSF_ENVDIR/hostregsetup

echo "LSF_SERVER_HOSTS=\"masterhost_ip\"" >> $LSF_CONF_FILE
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resource docker]\"/" $LSF_CONF_FILE
#
# Start LSF Daemons 
#
#sudo -E $LSF_SERVERDIR/lsf_daemons start
#sudo -E $lsf_TOP/10.1/linux3.10-glibc2.17-x86_64/etc/lsf_daemons restart
#lsadmin limstartup
#lsadmin resstartup

#badmin hstartup
sudo mkdir -p /fsx_shared
sudo chmod 777 /fsx_shared
sudo systemctl stop firewalld || /bin/true
sudo systemctl disable firewalld || /bin/true
sudo chmod 777 /SCRATCH || /bin/true

#calling the aws_volume_attachment.sh script 
if [ "${rc_account}" == "rc_nfs" ]; then
    sudo chmod +x /fsx_shared/Install_Scripts/nvme_mount.sh >> $logfile
   /fsx_shared/Install_Scripts/nvme_mount.sh >> $logfile
fi

#pulling latest docker images specified by the user from userdata.json
if [ "$SPILLBOX_CONTAINER" == "docker" ]; then
    sudo service docker start
    JSON_FILE="/fsx_shared/lsf_shared_directory/tools/userdata.json"
    REGISTRIES=$(jq -r '.registries[]' "$JSON_FILE")
    IMAGES=$(jq -r '.images[]' "$JSON_FILE")
    if [ "$IMAGES" != "" ]; then
        file="/etc/docker/daemon.json"
        tmpfile="/tmp/daemon.json"
        sudo cp /etc/docker/daemon.json /etc/docker/daemon.json.bak
        changes_done=0
        for registry in $REGISTRIES ; do
            tmp=$(sudo jq '.["insecure-registries"]' "$file" 2> /dev/null)
            if [ "$tmp" != "null" ]; then
                if `sudo jq --arg registry "${registry}" 'any(.["insecure-registries"][] == $registry; .)' "$file"` == "true" ; then
                    echo "The registry $registry is already present in $file" >>  $logfile
                else
                    sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                    sudo mv "$tmpfile" "$file"
                    changes_done=1
                    echo "Registry ${registry} added successfully." >>  $logfile
                fi
            else
                echo "Registry ${registry}  added successfully." >>  $logfile
                sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                changes_done=1
                sudo mv "$tmpfile" "$file"
            fi
        done
    if test $changes_done -eq 1 ; then
            sudo cp /lib/systemd/system/docker.service /etc/systemd/system/
            sudo bash -c "sed -i 's/\ -H\ fd:\/\///g' /etc/systemd/system/docker.service"
            sudo systemctl daemon-reload >>  $logfile
            sudo service docker restart >>  $logfile
        fi
        for IMAGE in $IMAGES; do
            echo "Pulling Docker image: $IMAGE" >>  $logfile
            docker pull "$IMAGE"  >>  $logfile
        done
    fi
fi

sudo -E $LSF_SERVERDIR/lsf_daemons start >> $logfile
sleep 45
sudo -E $LSF_SERVERDIR/lsf_daemons restart >> $logfile

echo END AT `date '+%Y-%m-%d %H:%M:%S'` >> $logfile

