#!/bin/sh -fx

logfile=/tmp/user_data.log
echo START `date '+%Y-%m-%d %H:%M:%S'` >> $logfile

# Export user data, which is defined with the "UserData" attribute 
# in the template
%EXPORT_USER_DATA%

LSF_TOP=/sbox_lsf/lsf
LSF_CONF_FILE=$LSF_TOP/conf/lsf.conf
. $LSF_TOP/conf/profile.lsf
env >> $logfile

echo "rc account arrived is :: $rc_account" >> $logfile
cat $LSF_CONF_FILE >> $logfile
if [ "${rc_account}" == "rc_nfs" ]; then
    sed -i "s/ocihost/ocihost1/" $LSF_CONF_FILE
fi

if [ -n "${rc_account}" ]; then
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resourcemap ${rc_account}*rc_account]\"/" $LSF_CONF_FILE
echo "update LSF_LOCAL_RESOURCES lsf.conf successfully, add [resourcemap ${rc_account}*rc_account]" >> $logfile
fi
sed -i "s/^LSF_SERVER_HOSTS/#LSF_SERVER_HOSTS/g" $LSF_CONF_FILE

echo "LSF_SERVER_HOSTS=\"masterhost_ip\"" >> $LSF_CONF_FILE
sed -i "s/\(LSF_LOCAL_RESOURCES=.*\)\"/\1 [resource docker]\"/" $LSF_CONF_FILE

sudo mkdir -p /fsx_shared
sudo chmod 777 /fsx_shared

# pulling latest docker images specified by the user from userdata.json
if [ "$SPILLBOX_CONTAINER" == "docker" ]; then
    sudo service docker start
    JSON_FILE="/fsx_shared/lsf_shared_directory/tools/userdata.json"
    REGISTRIES=$(jq -r '.registries[]' "$JSON_FILE")
    IMAGES=$(jq -r '.images[]' "$JSON_FILE")
    if [ "$IMAGES" != "" ]; then
        file="/etc/docker/daemon.json"
        tmpfile="/tmp/daemon.json"
        sudo cp /etc/docker/daemon.json /etc/docker/daemon.json.bak
        changes_done=0
        for registry in $REGISTRIES ; do
            tmp=$(sudo jq '.["insecure-registries"]' "$file" 2> /dev/null)
            if [ "$tmp" != "null" ]; then
                if `sudo jq --arg registry "${registry}" 'any(.["insecure-registries"][] == $registry; .)' "$file"` == "true" ; then
                    echo "The registry $registry is already present in $file" >>  $logfile
                else
                    sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                    sudo mv "$tmpfile" "$file"
                    changes_done=1
                    echo "Registry ${registry} added successfully." >>  $logfile
                fi
            else
                echo "Registry ${registry}  added successfully." >>  $logfile
                sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                changes_done=1
                sudo mv "$tmpfile" "$file"
            fi
        done
        if test $changes_done -eq 1 ; then
            sudo cp /lib/systemd/system/docker.service /etc/systemd/system/
            sudo bash -c "sed -i 's/\ -H\ fd:\/\///g' /etc/systemd/system/docker.service"
            sudo systemctl daemon-reload >>  $logfile
            sudo service docker restart >>  $logfile
        fi
        for IMAGE in $IMAGES; do
            echo "Pulling Docker image: $IMAGE" >>  $logfile
            docker pull "$IMAGE"  >>  $logfile
        done
    fi
fi

#starting LSF
sudo -E $LSF_SERVERDIR/lsf_daemons start >> $logfile
sleep 45
sudo -E $LSF_SERVERDIR/lsf_daemons restart >> $logfile

echo END AT `date '+%Y-%m-%d %H:%M:%S'` >> $logfile

