resource "tls_private_key" "default" {
  count     = var.enabled
  algorithm = "RSA"
  rsa_bits  = 4096
}

resource "local_file" "public_key_openssh" {
  count                = var.enabled
  depends_on           = [tls_private_key.default]
  sensitive_content    = tls_private_key.default[0].public_key_openssh
  filename             = var.public_key_filename
  file_permission      = "0600"
  directory_permission = "0700"
}

resource "local_file" "private_key_pem" {
  count                = var.enabled
  depends_on           = [tls_private_key.default]
  sensitive_content    = tls_private_key.default[0].private_key_pem
  filename             = var.private_key_filename
  file_permission      = "0600"
  directory_permission = "0700"
}

resource "null_resource" "chmod" {
  count      = var.enabled
  depends_on = [local_file.private_key_pem]

  triggers = {
    local_file_private_key_pem = local_file.private_key_pem[0].filename
  }

  provisioner "local-exec" {
    command = format(var.chmod_command, var.private_key_filename)
  }
}


