resource "aws_instance" "compute" {
  count                  = var.webserver_create == "true" ? 1 : 0
  ami                    = var.ami_name
  instance_type          = var.instance_type
  vpc_security_group_ids = var.vpc_security_group_ids
  iam_instance_profile   = var.iam_instance_profile

  user_data = data.template_cloudinit_config.config.rendered

  subnet_id                   = var.subnet_id
  key_name                    = var.key_name
  #associate_public_ip_address = false
  root_block_device {
    volume_size           = var.root_volume_size
    kms_key_id            = var.kms_key_id == "" ? null : var.kms_key_id
    encrypted             = var.kms_key_id == "" ? false : true
    delete_on_termination = true
  }

  tags = {
    Name = var.Name
  }

  provisioner "local-exec" {
    command = "sleep ${var.wait_time_vm} && echo done waiting master VM ready"
  }
}

resource "null_resource" "fsx_client" {
  count = var.webserver_create == "true" ? 1 : 0
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = element(flatten(aws_instance.compute.*.private_ip), 0)
    port        = var.cloud_ssh_port
    timeout     = "600s"
  }
  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }
  provisioner "remote-exec" {
    inline = ["chmod 755 /tmp/install/install.sh; /tmp/install/install.sh '${var.spillbox_container}' '${var.vm_user}' '${var.docker_registry}' '${var.docker_images}' '${var.service_userid}' 'true' '${var.cluster_create}'"]
  }
}

resource "null_resource" "fsx_client_singularity_sif" {
  count = var.spillbox_container == "singularity" ? 1 : 0
  provisioner "file" {
    source      = "${var.singularity_sifpath}"
    destination = "/spillbox_sif/${basename(var.singularity_sifpath)}"
  }
}

resource "null_resource" "fsx_client_local" {
  count = var.webserver_create == "false" ? 1 : 0

  provisioner "local-exec" {
    command = "chmod 755 ${path.module}/install/install.sh && ${path.module}/install/install.sh '${var.spillbox_container}' '${var.vm_user}' '${var.docker_registry}' '${var.docker_images}' '${var.service_userid}' 'false' '${var.cluster_create}'"
  }
}

resource "null_resource" "fsx_client_local_singularity_sif" {
  count = var.spillbox_container == "singularity" ? 1 : 0
  provisioner "local-exec" {
    command = "sudo cp -r ${var.singularity_sifpath} /spillbox_sif/${basename(var.singularity_sifpath)}"
  }
}
