locals {
  nfs_tag_map = merge(
    { Name = var.Name },
    var.nfs_tag == "" ? {} : tomap({
      for item in [for pair in split(",", var.nfs_tag) : split("=", pair)] : item[0] => item[1]
    })
  )
}

resource "aws_instance" "instance" {
  count                  = var.number
  ami                    = var.ami_name
  instance_type          = var.instance_type
  iam_instance_profile   = var.iam_instance_profile
  vpc_security_group_ids = var.vpc_security_group_ids

  user_data = data.template_cloudinit_config.config.rendered

  subnet_id                   = var.subnet_id
  key_name                    = var.key_name
  #associate_public_ip_address = false
  tags                        = local.nfs_tag_map

  root_block_device {
    volume_size           = var.root_volume_size
    kms_key_id            = var.kms_key_id == "" ? null : var.kms_key_id
    encrypted             = var.kms_key_id == "" ? false : true
    delete_on_termination = true
  }

  provisioner "local-exec" {
    command = "sleep ${var.wait_time_vm} && echo done waiting master VM ready"
  }
}

resource "null_resource" "fsx_client" {
  count = var.number
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = element(flatten(aws_instance.instance.*.private_ip), count.index)
    port        = var.cloud_ssh_port
    timeout     = "600s"
  }
  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh"]
  }
  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/nvme_mount.sh; sudo /tmp/install/nvme_mount.sh"]
  } 
}
