#!/bin/bash -f

timeout_duration=600
time_done=0
ephemeral_disks=""
declare -i DISK_COUNT=0

while [ $time_done -lt $timeout_duration ]; do
    VOLUMES_NAME=$(find /dev | grep -i 'nvme[0-21]n1$')

    if [ -z "$VOLUMES_NAME" ]; then
        VOLUMES_NAME=$(find /dev | grep -i 'xvdf')
        if [ "$VOLUMES_NAME" != "" ]; then
            break
        fi
        echo "Timeout: VOLUMES_NAME not populated within $timeout_duration seconds."
    else
        echo "Found Volumes:"
        echo "$VOLUMES_NAME" | tr " " "\n"

        for VOLUME in $VOLUMES_NAME; do
            DISK=$(nvme id-ctrl -v "$VOLUME" | grep -Po 'ephemeral|/dev/(sd[b-z]|xvd[b-z])|Amazon.*EC2.*NVMe.*Instance.*Storage')
            if [ ! -z "$DISK" ]; then
                let DISK_COUNT++
                echo "Added disk $VOLUME, $DISK_COUNT so far"
                ephemeral_disks="$ephemeral_disks $VOLUME"
            fi
        done
        sleep 10
        ((time_done += 10))
    fi
done

# Create a filesystem on the detected ephemeral disks
for disk in $ephemeral_disks; do
    echo "Formatting $disk with ext4 filesystem..."
    mkfs -t ext4 "$disk"
done
# Create a RAID0 array (replace with your desired name)
mdadm --create /dev/md0 --level=raid0 --raid-devices=$${DISK_COUNT} $${ephemeral_disks} --force --run
