#!/usr/bin/env bash
set -o nounset
set -o errexit
set -o pipefail


VOLUME_NAME="${volume_name}"
NAME=$(echo $${VOLUME_NAME})
echo "---> Waiting for $NAME (. = 5s)"
timeout 180 /bin/bash -c "until stat $NAME 2>/dev/null; do echo waiting for $NAME ...; sleep 5; done"
MOUNT_POINT="${mount_point}"
MOUNT_POINT_BACKUP="${mount_point}-backup"
INMEMORY="${inmemory}"
FS="${file_system}"
LIMIT="${limit}"
MEMTOTAL=$(expr $(vmstat -s | grep "total memory" | awk '{print $1}'))
MEMTOTAL=$(($MEMTOTAL / 1048576 ))
TMPFS_SIZE="${tmpfs_size}"
DISK_SIZE=$(/sbin/fdisk -l $NAME | grep ^Disk | awk '{print $3}')
DISK_UNIT=$(/sbin/fdisk -l $NAME | grep ^Disk | awk '{print $4}' | sed 's/,//g')
if [ "$DISK_UNIT" == "TiB" ] ; then
    DISK_SIZE=$(echo $DISK_SIZE | sed 's/,//g' | awk -F. '{print $1}')
    let DISK_SIZE=$DISK_SIZE*1024
fi

if [ "$MEMTOTAL" -lt "$LIMIT" ] ; then
    if [ "$INMEMORY" = true ] ; then
        INMEMORY=false
    fi
fi

echo "===> UserData Script: Start"

if $INMEMORY ; then
    echo '---> Creating Mount point'
    mkdir -p $${MOUNT_POINT}
    echo '---> Creating swap volume'
    mkswap $${VOLUME_NAME}
    echo '---> Swapon EBS'
    swapon $${VOLUME_NAME}
    TMPFS_SIZE=$(expr $MEMTOTAL - $LIMIT)
    echo '---> Mount tmpfs'
    let TMPFS_SIZE=($TMPFS_SIZE+$DISK_SIZE)
    mount -t tmpfs -o size=$${TMPFS_SIZE}G tmpfs $${MOUNT_POINT}

else
    echo '---> Creating File System'
    mkfs -t $${FS} $${VOLUME_NAME}
    echo '---> Creating Mount point'
    mkdir -p $${MOUNT_POINT}
    echo '---> Retrieve UUID EBS'
    VOLUME_UUID=$(blkid -s UUID -o value $${VOLUME_NAME})
    echo '---> Mount EBS'
    mount UUID="$${VOLUME_UUID}" $${MOUNT_POINT}
    echo '---> Saving Mount point'
    echo "UUID="$${VOLUME_UUID}" $${MOUNT_POINT} $${FS} defaults,nofail 0 2" | sudo tee -a /etc/fstab
    echo '---> RollMove Data'
    shopt -s dotglob
fi

echo "===> UserData Script: Done"

