terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.62.0"
    }
    null = {
      version = "3.2.3"
    }
    template = {
      version = "2.2.0"
    }
  }
  backend "s3" {
    key     = "states/job_machine"
    encrypt = true
  }
}

provider "aws" {
  region = var.region
}

data "terraform_remote_state" "webserver" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    key    = "states/webserver"
  }
}

module "job_machine" {
  source = "../../aws/compute/"
  count  = var.enable_sgo == "false" ? 0 : 1

  number               = var.min_compute_count
  instance_type        = var.compute_instance_type == "" ? var.job_instance_type[var.model] : var.compute_instance_type
  ami_name             = var.spillbox_imageid
  subnet_id            = data.terraform_remote_state.webserver.outputs.public_subnet_id
  webserver_private_ip = data.terraform_remote_state.webserver.outputs.master_private_ip
  key_name             = data.terraform_remote_state.webserver.outputs.key_name
  security_group_id    = [data.terraform_remote_state.webserver.outputs.public_security_group_id]
  Name                 = "${var.servername}-job"
  private_key          = var.project_private_key
  iam_instance_profile = data.terraform_remote_state.webserver.outputs.instance_profile_name
  vm_user              = var.vm_user
  cloud_ssh_port       = var.cloud_ssh_port
  dnsname              = data.terraform_remote_state.webserver.outputs.dnsname
  mountname            = data.terraform_remote_state.webserver.outputs.mountname
  root_volume_size     = var.compute_volume_size
  compute_tag          = var.compute_tag == "" ? "" : "${var.compute_tag}"
  kms_key_id             = var.kms_key_id
}
