variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "servername" {
  description = "server tag name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}

variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}

variable "compute_instance_type" {}
variable "job_instance_type" {
  description = "Provides an EC2 instance resource for slurm master"
  type        = map(string)

  default = {
    small  = "m5.large"
    medium = "m5.2xlarge"
    large  = "m5.4xlarge"
  }
}
variable "min_compute_count" {
  description = "Compute machine count"
}
variable "cloud_ssh_port" {}
variable "project_private_key" {}
variable "enable_sgo" {}
variable "compute_volume_size" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
}
variable "compute" {}
variable "nfs" {}
variable "spillbox_imageid" {}
variable "compute_tag" {}
variable "kms_key_id" {}
