terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.62.0"
    }
    null = {
      version = "3.2.3"
    }
  }
  backend "s3" {
    key     = "states/lsf"
    encrypt = true
  }
}

provider "aws" {
  region = var.region
}
data "terraform_remote_state" "webserver" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    key    = "states/webserver"
  }
}
data "terraform_remote_state" "nfsmachine" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    key    = "states/nfs_machine"
  }
}

data "terraform_remote_state" "jobmachine" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    key    = "states/job_machine"
  }
}

module "installsf" {
  source                   = "../../../modules/lsf/"
  cloud_provider           = var.cloud_provider
  min_compute_number       = var.min_compute_count
  max_compute_number       = var.max_compute_count
  min_nfs_number           = var.min_nfs_count
  max_nfs_number           = var.max_nfs_count
  compute_instance_type    = var.compute_instance_type == "" ? "m5.large" : var.compute_instance_type
  nfs_instance_type        = var.nfs_instance_type == "" ? "i3en.xlarge" : var.nfs_instance_type
  nfs_cpu_limit            = var.nfs_cpu_limit
  webserver_create         = var.webserver_create
  iam_instance_profile     = data.terraform_remote_state.webserver.outputs.instance_profile_name
  customer                 = var.customer
  servername               = var.servername
  region                   = var.region
  project                  = "Not needed for aws"
  vpcid                    = var.vpc_id == "" ? data.terraform_remote_state.webserver.outputs.vpc_id : var.vpc_id
  subnetid                 = var.subnet_id == "" ? [data.terraform_remote_state.webserver.outputs.public_subnet_id] : [var.subnet_id]
  securitygroupid          = var.security_group_id == "" ? [data.terraform_remote_state.webserver.outputs.public_security_group_id] : [var.security_group_id]
  master_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.webserver.outputs.master_private_ip]
  worker_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.jobmachine.outputs.compute_private_ip]
  splfs_private_ip         = var.enable_sgo == "false" ? null : [data.terraform_remote_state.nfsmachine.outputs.splfs_private_ips]
  vm_user                  = var.vm_user
  cloud_ssh_port           = var.cloud_ssh_port
  nfsami_id                = var.spillboxcompute_imageid
  computeami_id            = var.spillboxcompute_imageid
  private_key              = var.enable_sgo == "false" ? var.ssh_keypriv : var.project_private_key
  dnsname                  = data.terraform_remote_state.webserver.outputs.dnsname
  mountname                = data.terraform_remote_state.webserver.outputs.mountname
  enable_sgo               = var.enable_sgo
  webserver                = var.webserver
  compute                  = var.compute
  nfs                      = var.nfs
  service_userid           = var.service_userid
  keyname                  = data.terraform_remote_state.webserver.outputs.key_name
  enable_lsfinstall        = var.enable_lsfinstall
  zone                     = "Not needed for AWS"
  max_spot_count           = var.max_spot_count
  max_spot_price           = var.max_spot_price
  spot_instance_type       = var.spot_instance_type == "" ? "m5.large" : var.spot_instance_type
  spot_allocation_strategy = var.spot_allocation_strategy
  spot_role                = data.terraform_remote_state.webserver.outputs.spotfleet_arnid
  spot_tag                 = var.spot_tag
  compute_tag              = var.compute_tag
  nfs_tag                  = var.nfs_tag
  compartment_ocid         = "Not needed"
  subnet_dns               = "Not needed"
  spillbox_container       = var.spillbox_container
  singularity_sifpath      = var.singularity_sifpath
  nfs_cpu                  = var.nfs_cpu
  nfs_mem                  = var.nfs_mem
  compute_cpu              = var.compute_cpu
  compute_mem              = var.compute_mem
  spot_cpu                 = var.spot_cpu
  spot_mem                 = var.spot_mem
}
