locals {
  vpc_id            = var.vpc_id == "" ? aws_vpc.vpc_main[0].id : var.vpc_id
  cidr_block        = "10.0.0.0/16"
  public_cidr_block = var.vpc_id == "" ? "10.0.1.0/24" : var.public_subnet_cidr == "" ? "10.0.1.0/24" : var.public_subnet_cidr
}

resource "aws_vpc" "vpc_main" {
  count      = var.vpc_id == "" ? 1 : 0
  cidr_block = local.cidr_block

  enable_dns_support   = true
  enable_dns_hostnames = true

  tags = {
    Name = "${var.customer}-Main-VPC"
  }
}

resource "aws_internet_gateway" "default" {
  count  = var.vpc_id == "" ? 1 : 0
  vpc_id = local.vpc_id
}

resource "aws_route" "internet_access" {
  count                  = var.vpc_id == "" ? 1 : 0
  route_table_id         = aws_vpc.vpc_main[0].main_route_table_id
  destination_cidr_block = "0.0.0.0/0"
  gateway_id             = aws_internet_gateway.default[0].id
}

# Create a public subnet to launch our load balancers
resource "aws_subnet" "public" {
  vpc_id                  = local.vpc_id
  cidr_block              = local.public_cidr_block
  map_public_ip_on_launch = true
  tags = {
    Name = "${var.customer}-public"
  }
  #availability_zone = var.region
}


