terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.62.0"
    }
    null = {
      version = "3.2.3"
    }
    template = {
      version = "2.2.0"
    }
  }
  backend "s3" {
    key     = "states/nfs_machine"
    encrypt = true
  }
}

provider "aws" {
  region = var.region
}

data "terraform_remote_state" "webserver" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    key    = "states/webserver"
  }
}

module "splfs" {
  count                  = var.enable_sgo == "false" ? 0 : 1
  source                 = "../../aws/compute_nvme"
  number                 = var.min_nfs_count
  Name                   = "${var.servername}-nfs"
  subnet_id              = data.terraform_remote_state.webserver.outputs.public_subnet_id
  customer               = "${var.customer}-${var.servername}"
  key_name               = data.terraform_remote_state.webserver.outputs.key_name
  vpc_security_group_ids = [data.terraform_remote_state.webserver.outputs.public_security_group_id]
  ami_name               = var.spillbox_imageid
  instance_type          = var.nfs_instance_type == "" ? var.splfs_instance_type[var.model] : var.nfs_instance_type
  vm_user                = var.vm_user
  iam_instance_profile   = data.terraform_remote_state.webserver.outputs.instance_profile_name
  public_key             = var.project_public_key
  private_key            = var.project_private_key
  cloud_user             = var.cloud_user
  project                = "not needed for aws"
  cache_dir              = var.cache_dir
  model                  = var.model
  data_in_memory         = var.data_in_memory
  dnsname                = data.terraform_remote_state.webserver.outputs.dnsname
  kms_key_id             = var.kms_key_id
  mountname              = data.terraform_remote_state.webserver.outputs.mountname
  zone                   = "Not needed for aws"
  cloud_ssh_port         = var.cloud_ssh_port
  root_volume_size       = var.nfs_volume_size
  nfs_tag                = var.nfs_tag == "" ? "" : "${var.nfs_tag}"
}
