variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "servername" {
  description = "Server Tag name"
}

variable "splfs_instance_type" {
  description = "Provides an EC2 instance resource for splfs server"
  type        = map(string)

  default = {
    small  = "i3en.xlarge"
    medium = "i3en.2xlarge"
    large  = "i3en.3xlarge"
  }
}
variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}
variable "data_in_memory" {
  type        = bool
  description = "File system in memory, not on disk"
}
variable "cloud_ssh_port" {}
variable "subnet_id" {}
variable "security_group_id" {}
variable "vm_user" {}
variable "cache_dir" {}
variable "min_nfs_count" {}
variable "cloud_user" {}
variable "enable_sgo" {}
variable "nfs_instance_type" {}
variable "webserver_instance_type" {}
variable "webserver_volume_size" {}
variable "nfs_volume_size" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
}
variable "compute" {}
variable "nfs" {}
variable "spillbox_imageid" {}
variable "project_public_key" {}
variable "project_private_key" {}
variable "nfs_tag" {}
variable "kms_key_id" {}
