# A security group for the ELB so it is accessible via the web
resource "aws_security_group" "public_elb" {
  name        = "sec_group_public_elb"
  description = "Security group for public facing ELBs"
  vpc_id      = var.vpc-id

  tags = {
    Name = var.customer
  }

  # SSH access from anywhere
  ingress {
    from_port   = var.cloud_ssh_port
    to_port     = var.cloud_ssh_port
    protocol    = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  # All from private
  ingress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = [var.public_cidr_blocks[0]]
  }

  # Outbound internet access
  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }
}

