terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.62.0"
    }
    null = {
      version = "3.2.3"
    }
    tls = {
      version = "4.0.6"
    }
    local = {
      version = "2.5.2"
    }
  }
}

provider "aws" {
  region = var.region
}

module "backend" {
  source                      = "../storage/backend"
  create                      = var.generate_ssh_key == true ? 1 : 0
  backend_bucket              = "ts-${var.customer}-${var.servername}"
  kms_key_id                  = ""
  dynamodb_lock_table_enabled = false
  region                      = var.region
}

locals {
  key_name = "${var.customer}-${var.servername}-auto-key"
  public_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.public_key_extension,
  )
  private_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.private_key_extension,
  )
  key_dir = format(
    "%s/%s-%s",
    var.secrets,
    var.customer,
    var.servername,
  )
}

resource "aws_key_pair" "imported" {
  count           = var.generate_ssh_key == false ? 1 : 0
  key_name_prefix = local.key_name
  public_key      = file(local.public_key_filename)
}

module "tls_private_key" {
  source               = "../../../modules/ssh_key_pair"
  enabled              = var.generate_ssh_key == true ? 1 : 0
  public_key_filename  = local.public_key_filename
  private_key_filename = local.private_key_filename
}

resource "aws_key_pair" "generated" {
  count      = var.generate_ssh_key == true ? 1 : 0
  depends_on = [module.tls_private_key]
  key_name   = local.key_name
  public_key = module.tls_private_key.public_key
}

