output "vpc_id" {
  value = var.vpc_id == "" ? module.subnet[0].vpc_id : var.vpc_id
}

output "public_subnet_id" {
  value = var.subnet_id == "" ? module.subnet[0].public_id : var.subnet_id
}

output "public_security_group_id" {
  value = var.security_group_id == "" ? module.security_group[0].public_id : var.security_group_id
}

output "region" {
  value = var.region
}

output "cloud_ssh_port" {
  value = var.cloud_ssh_port
}

output "public_subnet_cidr" {
  value = var.subnet_id == "" ? "${join(",", module.subnet[0].public_cidr_blocks)}" : var.public_subnet_cidr
}

output "key_name" {
  value = module.ssh_key_pair.key_name
}

output "master_private_ip" {
  value = var.enable_sgo == "false" ? [[var.webserver[0]]] : module.webserver[0].private_ip
}
output "mountname" {
  value = aws_fsx_lustre_file_system.fsxshared.mount_name
}

output "dnsname" {
  value = aws_fsx_lustre_file_system.fsxshared.dns_name
}
output "vm_user" {
  value = var.vm_user
}
output "spotfleet_arnid" {
  value = aws_iam_role.spotfleet_role.arn
}
output "instance_profile_name" {
  description = "The ID of the IAM instance profile"
  value       = aws_iam_instance_profile.spillbox_s3_instance_profile.name
}
