# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "number" {
  description = "Number of controller to deploy"
}

variable "zone" {
  description = "Azure location to launch servers."
}

variable "project" {
  description = "Resource group name in which VM is instanciated."
}

variable "instance_type" {
  description = "Specifies the size of the virtual machine."
}

variable "subnet_id" {
  description = "Network interface id."
}

variable "vm_user" {
  description = "Administrator user name"
}

variable "public_key" {
  description = "ssh public key filename"
}

variable "ami_name" {}
variable "Name" {
  description = "VM Name tag"
}



variable "key_name" {}

variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "180"
}
variable "cloud_ssh_port" {}
variable "mountname" {}
variable "dnsname" {}
variable "webserver_private_ip" {}
variable "private_key" {}
variable "root_volume_size" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}
variable "compute_tag" {}
variable "ami_plan" {}
