variable "number" {
  description = "Number of controller to deploy"
}

variable "ami_name" {
  description = "EC2 AMI resource"
}

variable "key_name" {
  description = "AWA EC2 Key Pair"
}

variable "instance_type" {
  description = "EC2 instance resource"
}

variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "180"
}

variable "subnet_id" {
  description = "VPC subnet id"
}
variable "vpc_security_group_ids" {
  type        = list(any)
  description = "List of EC2 instance VPC security group resource ids"
}
variable "Name" {
  description = "EC2 Name tag"
}
variable "project" {}
variable "zone" {}
variable "vm_user" {}
variable "private_key" {}
variable "public_key" {}
variable "mountname" {}
variable "dnsname" {}
variable "customer" {}
variable "cloud_ssh_port" {}
variable "root_volume_size" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}
variable "docker_registry" {}
variable "docker_images" {}
variable "clientid" {}
variable "tenantid" {}
variable "clientsecret" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "ami_plan" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
