#!/bin/bash -fx
#1: currentnodeip 2:serviceuser_id 3:webserverip 4:cluster_create
centos=0
alinux=0
rhel=0
FILE_SYSTYPE=$(findmnt -no FSTYPE /)
ADMIN_USER=$(whoami)
ADMIN_UID=$(id -u)
DOCKER_IMAGES="spillbox"

hostip="$1"
SERVICE_USERID="$2"
WEBSERVER_IP="$3"

APT="apt-get"
UPDATE="update"
OSID=$(cat /etc/os-release | grep ^ID= | awk -F= '{print $2}' | sed 's/"//g')
if [[ $OSID == "centos" || $OSID == "amzn" ]]; then
    APT="yum"
    centos=1
    UPDATE="check-update --skip-broken -y"
    centos_version=$(rpm -E %{rhel})
    if [[ -f /etc/centos-release && ( "$centos_version" == "7" || "$centos_version" == "8" ) ]]; then
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/mirror.centos.org/vault.centos.org/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^#.*baseurl=http/baseurl=http/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^mirrorlist=http/#mirrorlist=http/g' {} +
    fi
fi

if [[ $OSID == "amzn" ]] ; then
    alinux=1
    UPDATE="check-update --skip-broken -y"
    APT="yum"
fi

if [ "$OSID" == "rhel" ]; then
    APT=yum
    rhel=1
fi

#Installing nvme cli for nvme mounting 
sudo $APT install -y sudo
sudo $APT install -y pam

XVD_DEVICES=$(lsblk -dn -o NAME | grep ^sd)
if [[ ! -z "$XVD_DEVICES" ]]; then
    VOLUME_NAME=$(echo "$XVD_DEVICES" | awk '{print "/dev/"$1}')
else
    NVME_DEVICES=$(lsblk -dn -o NAME | grep ^nvme)
    VOLUME_NAME=$(echo "$NVME_DEVICES" | awk '{print "/dev/"$1}')
fi

for VOLUME in ${VOLUME_NAME[@]}
do
# Check if the device exists
    if [[ ! -b "$VOLUME" ]]; then
        echo "Error: $VOLUME does not exist."
        exit 1
    fi
    VOLUME_TYPE=$(basename "$VOLUME")
    if [[ "$VOLUME_TYPE" =~ ^nvme[0-9]n1$ ]]; then
        DEVICE_NAME="$VOLUME"
        DEVICE_SHORT=$(basename $DEVICE_NAME)
        #check for partition exist
        check_partition=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "$DEVICE_SHORT" | sort -k3 -h | grep part )
        if [ "$check_partition" == "" ]; then
            PARTITION_NAME=""
        else
            PARTITION_NAME=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "$DEVICE_SHORT" | grep -v disk | sort -k3 -h | tail -n 1| awk '{print "/dev/"$1}' )
        fi
        #check if partition is mounted ,if mounted take the root volume (REASON UUID same)
        CHECK_MOUNTED=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^$DEVICE_SHORT" | grep -v disk | sort -k3 -h | tail -n 1 | awk -F ' ' '{print $4}')
        if [ "$CHECK_MOUNTED" == "/" ]; then
            DEVICE_NAME="/dev/nvme0n1"
            DEVICE_SHORT=$(basename $DEVICE_NAME)
            check_partition=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^nvme0n[0-9]" | sort -k3 -h | grep part)
            if [ "$check_partition" == "" ]; then
                PARTITION_NAME=""
            else
                PARTITION_NAME=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^nvme0n[0-9]" | grep -v disk | sort -k3 -h | tail -n 1 | awk '{print "/dev/"$1}')
            fi
        fi
        break
    else
        DEVICE_NAME="$VOLUME"
        DEVICE_SHORT=$(basename $DEVICE_NAME)
        check_partition=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^sdc[0-9]" | sort -k3 -h | grep part)
        if [ "$check_partition" == "" ]; then
             PARTITION_NAME=""
        else
            PARTITION_NAME=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^sdc[0-9]" | grep -v disk | sort -k3 -h | tail -n 1 | awk '{print "/dev/"$1}')
        fi
        #check if partition is mounted ,if mounted take the root volume (REASON UUID same)
        CHECK_MOUNTED=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^sdc[0-9]" | sort -k3 -h | tail -n 1 | awk -F ' ' '{print $4}')
        if [ "$CHECK_MOUNTED" == "/" ]; then
            DEVICE_NAME="/dev/sda"
            DEVICE_SHORT=$(basename $DEVICE_NAME)
            check_partition=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^sda[0-9]" | sort -k3 -h | grep part)
            if [ "$check_partition" == "" ]; then
                PARTITION_NAME=""
            else
                PARTITION_NAME=$(sudo lsblk -nr -o NAME,TYPE,SIZE,MOUNTPOINT | grep -E "^sda[0-9]" | grep -v disk | sort -k3 -h | tail -n 1 | awk '{print "/dev/"$1}')
            fi
        fi
        if [ ! -z $DEVICE_NAME ]; then
            break
        fi
    fi
done

if [  "$PARTITION_NAME" == "" ]; then
    echo "No partitions found on $DEVICE_NAME. Creating a new partition..."
    # Create a new partition (single primary partition)
    echo ",,83" | sudo sfdisk "$DEVICE_NAME"
    # Refresh partition table
    sudo partprobe "$DEVICE_NAME"
    sleep 5
    echo "Partition created successfully."
    DEVICE_NAME=$(sudo lsblk -nr -o NAME,TYPE | grep -E "$DEVICE_SHORT" | grep part | awk '{print "/dev/"$1}')
else
    echo "Partition already exists on $DEVICE."
    DEVICE_NAME=$PARTITION_NAME
fi

if [ "$FILE_SYSTYPE" == "xfs" ]; then
    XFS_ADMIN=$(sudo xfs_admin -U generate "$DEVICE_NAME")
    if echo "$XFS_ADMIN" | grep -q "valuable metadata changes in a log"; then
        sudo xfs_repair -L "$DEVICE_NAME"
        sudo xfs_admin -U generate "$DEVICE_NAME"
    fi
elif [ "$FILE_SYSTYPE" == "ext4" ]; then
    sudo e2fsck -f "$DEVICE_NAME"
    echo y | sudo tune2fs -U random "$DEVICE_NAME"
else
    echo "File system not matched with XFS or EXT4. Please check the File system"
    exit 1
fi

if test ${PIPESTATUS[0]} -eq 0 ; then
    sudo mount "$DEVICE_NAME" /mnt
else
    echo "Mount Failed"
fi

sudo systemctl stop firewalld.service


if [[ $centos -eq 1 || $rhel -eq 1 ]]; then
    sudo $APT install -y wget
    if  test $rhel -eq 1 ; then
        rhel_version=$(rpm -E %{rhel})
        wget -P /tmp https://dl.fedoraproject.org/pub/epel/epel-release-latest-${rhel_version}.noarch.rpm
        sudo $APT install -y /tmp/epel-release-latest-${rhel_version}.noarch.rpm
    else
        sudo $APT install -y epel-release
    fi
    sudo $APT install -y vim jq patchelf
    sudo $APT install -y cachefilesd
    sudo $APT install -y ypbind
elif [[ $alinux -eq 1 ]]; then
    sudo $APT install -y wget
    sudo amazon-linux-extras install epel -y
    sudo $APT install -y jq patchelf
    sudo $APT install -y cachefilesd
    sudo $APT install -y ypbind
else
    sudo $APT install -y wget vim patchelf
    sudo $APT install -y cachefilesd
    sudo $APT install -y nis
fi
which docker > /dev/null
ret=$?
if test $ret -ne 0 ; then
    if [[ $centos -eq 1 ]]; then
        sudo yum-config-manager --add-repo https://download.docker.com/linux/centos/docker-ce.repo
        sudo $APT install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
    elif [[ $rhel -eq 1 ]]; then
        sudo $APT install -y dnf
        sudo dnf -y install dnf-plugins-core
        sudo dnf -y config-manager --add-repo https://download.docker.com/linux/rhel/docker-ce.repo
        sudo dnf -y install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
    elif [[ $alinux -eq 1 ]]; then
        sudo amazon-linux-extras install docker -y
        sudo $APT install -y docker
    else
        sudo $APT install -y ca-certificates curl
        sudo install -m 0755 -d /etc/apt/keyrings
        sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /etc/apt/keyrings/docker.gpg
        sudo chmod a+r /etc/apt/keyrings/docker.gpg
        echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.gpg] https://download.docker.com/linux/ubuntu \
  $(. /etc/os-release && echo "$VERSION_CODENAME") stable" | \
        sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
        sudo $APT $UPDATE
        sudo $APT install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
    fi
fi
sudo systemctl enable docker
sudo systemctl start docker
hash -r
which docker > /dev/null
ret=$?
if test $ret -ne 0 ; then
    echo "Docker installation Failed..."
    exit 1
fi
sudo usermod -aG docker ${ADMIN_USER}

#disabling PAM for sudo session
echo 'Defaults !pam_session' | sudo tee -a /mnt/etc/sudoers
sudo -i bash <<EOF
cd /

EXCLUDES=""

echo "Docker is installed. Excluding Docker-related directories..."
EXCLUDES+=" --exclude=var/lib/docker"
EXCLUDES+=" --exclude=run/docker"
EXCLUDES+=" --exclude=etc/docker"
EXCLUDES+=" --exclude=usr/bin/docker"
EXCLUDES+=" --exclude=usr/bin/containerd"
EXCLUDES+=" --exclude=var/run/docker.sock"
tar -c -C /mnt/ \$EXCLUDES . | docker import - tarimg-spillbox
EOF

SERVICE_USER_UID=$(echo $SERVICE_USERID | awk -F ':' '{print $1}')
SERVICE_USER_NAME=$(echo $SERVICE_USERID | awk -F ':' '{print $3}')
mkdir -p spl-ser
echo "Building docker image with spillbox docker layer..."
(cd spl-ser ; 
curl -O https://s3-us-west-1.amazonaws.com/spillbox.io-public/spill-dc/v1.3/spill-dc.tar.gz ; tar xvf spill-dc.tar.gz ;
sudo docker build . --build-arg SERVER_IMAGE=tarimg-spillbox --build-arg ADMIN_USER=$SERVICE_USER_NAME --build-arg ADMIN_UID=$SERVICE_USER_UID  -f image/Dockerfile.wrapper -t spillbox --network=host ) &> /tmp/build.log
echo ...
file="/etc/docker/daemon.json"
tmpfile="/tmp/daemon.json"
registry="$WEBSERVER_IP:5000"
changed=0
if [[ -f $file && "$(sudo cat $file 2> /dev/null)" != "" ]]; then
    # Check if the registry already exists in the file
    tmp=$(sudo jq '."insecure-registries"' "$file" 2> /dev/null)
    if [ "$tmp" != "null" ]; then
        if sudo jq --arg registry "$registry" 'any(."insecure-registries"[] == $registry; .)' "$file" | grep -q true; then
            echo "The registry $registry is already present in $file"
        else
            changed=1
            sudo jq --arg registry "$registry" '."insecure-registries" += [$registry]' "$file" > "$tmpfile"
            sudo mv "$tmpfile" "$file"
            echo "Registry value added successfully."
        fi
    else
        changed=1
        sudo jq --arg registry "$registry" '."insecure-registries" = [$registry]' "$file" > "$tmpfile"
        sudo mv "$tmpfile" "$file"
        echo "Registry value added successfully."
    fi
else
    changed=1
    # Create a new daemon.json file
    sudo bash -c "cat << 'END' > $file
{
    \"hosts\": [\"unix:///var/run/docker.sock\",\"tcp://0.0.0.0:2375\"],
    \"insecure-registries\": [\"$registry\"]
}
END"
    echo "Daemon.json file created successfully."
fi

#internal debug will optimize it before production
if test $changed -eq 1; then
    sudo cat /etc/docker/daemon.json
    sudo cp /lib/systemd/system/docker.service /etc/systemd/system/
    sudo bash -c "sed -i 's/\ -H\ fd:\/\///g' /etc/systemd/system/docker.service"
    sudo systemctl daemon-reload
    sudo service docker restart
fi


echo "Pushing created docker images to registry : ${registry}"

sudo su - "${ADMIN_USER}" -c "docker tag spillbox ${registry}/spillbox"
sudo su - "${ADMIN_USER}" -c "docker push ${registry}/spillbox" >/dev/null
