#!/bin/bash

which patchelf
RET=$?
if test $RET -ne 0; then
    echo "[ERROR] patchelf not installed."
else
    echo "[OK] patchelf is installed."
fi
which aws 
RET=$?
if test $RET -ne 0; then
    echo "[ERROR] patchelf not installed."
else
    echo "[OK] aws is installed."
fi
# Function to check if a service is enabled and active
check_service() {
    SERVICE=$1
    if systemctl list-unit-files | grep -q "^$SERVICE.service"; then
        echo "[OK] $SERVICE service is installed."

        if systemctl is-enabled "$SERVICE" &> /dev/null; then
            echo "[OK] $SERVICE is enabled."
        else
            echo "[WARNING] $SERVICE is NOT enabled."
        fi

        if systemctl is-active "$SERVICE" &> /dev/null; then
            echo "[OK] $SERVICE is running."
        else
            echo "[WARNING] $SERVICE is NOT running."
        fi
    else
        echo "[ERROR] $SERVICE service is NOT installed."
    fi
}

check_ulimit() {
    CURRENT_ULIMIT=$(ulimit -n)
    TARGET_ULIMIT=102400

    if [ "$CURRENT_ULIMIT" -eq "$TARGET_ULIMIT" ]; then
        echo "[OK] ulimit is set to $TARGET_ULIMIT."
    else
        echo "[WARNING] ulimit is $CURRENT_ULIMIT, expected $TARGET_ULIMIT."
    fi
}

check_ulimit
# Check if rpc-statd service is installed, enabled, and active
check_service "rpc-statd"

