terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    azurerm = {
      version = "4.17.0"
    }
    null = {
      version = "3.2.3"
    }
    template = {
      version = "2.2.0"
    }
  }
  backend "azurerm" {
    key     = "states/job_machine"
    use_msi = true
  }
}

provider "azurerm" {
  features {
    resource_group {
      prevent_deletion_if_contains_resources = false
    }
  }
}

data "terraform_remote_state" "webserver" {
  backend = "azurerm"
  config = {
    resource_group_name  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
    storage_account_name = "${var.customer}${var.customer_project}"
    container_name       = "${var.customer}"
    key                  = "states/webserver"
    use_msi              = true
  }
}

module "job_machine" {
  source               = "../../azure/compute/"
  count                = var.enable_sgo == "false" ? 0 : 1
  number               = var.min_compute_count
  instance_type        = var.compute_instance_type == "" ? var.job_instance_type[var.model] : var.compute_instance_type
  ami_name             = var.spillbox_imageid
  ami_plan             = var.base_ami_plan == "" ? data.terraform_remote_state.webserver.outputs.ami_plan : var.base_ami_plan
  subnet_id            = data.terraform_remote_state.webserver.outputs.public_subnet_id
  key_name             = data.terraform_remote_state.webserver.outputs.key_name
  Name                 = "${var.customer_project}-job"
  public_key           = data.terraform_remote_state.webserver.outputs.public_key
  webserver_private_ip = data.terraform_remote_state.webserver.outputs.master_private_ip
  private_key          = data.terraform_remote_state.webserver.outputs.private_key
  vm_user              = var.vm_user
  cloud_ssh_port       = var.cloud_ssh_port
  project              = data.terraform_remote_state.webserver.outputs.project
  zone                 = var.region
  dnsname              = data.terraform_remote_state.webserver.outputs.dnsname
  mountname            = data.terraform_remote_state.webserver.outputs.mountname
  root_volume_size     = var.compute_volume_size
  compute_tag          = var.compute_tag == "" ? "" : "${var.compute_tag}"
}
