terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    azurerm = {
      version = "4.17.0"
    }
    null = {
      version = "3.2.3"
    }
  }
  backend "azurerm" {
    key     = "states/lsf"
    use_msi = true
  }
}

provider "azurerm" {
  features {
    resource_group {
      prevent_deletion_if_contains_resources = false
    }
  }
}

data "terraform_remote_state" "webserver" {
  backend = "azurerm"
  config = {
    resource_group_name  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
    storage_account_name = "${var.customer}${var.customer_project}"
    container_name       = "${var.customer}"
    key                  = "states/webserver"
    use_msi              = true
  }
}
data "terraform_remote_state" "nfsmachine" {
  backend = "azurerm"
  config = {
    resource_group_name  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
    storage_account_name = "${var.customer}${var.customer_project}"
    container_name       = "${var.customer}"
    key                  = "states/nfs_machine"
    use_msi              = true
  }
}

data "terraform_remote_state" "jobmachine" {
  backend = "azurerm"
  config = {
    resource_group_name  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
    storage_account_name = "${var.customer}${var.customer_project}"
    container_name       = "${var.customer}"
    key                  = "states/job_machine"
    use_msi              = true
  }
}


module "installlsf" {
  source                   = "../../../modules/lsf/"
  cloud_provider           = var.cloud_provider
  min_compute_number       = var.min_compute_count
  min_nfs_number           = var.min_nfs_count
  max_compute_number       = var.max_compute_count
  max_nfs_number           = var.max_nfs_count
  compute_instance_type    = var.compute_instance_type == "" ? "Standard_D2s_v3" : var.compute_instance_type
  nfs_instance_type        = var.nfs_instance_type == "" ? "Standard_E2ds_v6" : var.nfs_instance_type
  nfs_cpu_limit            = var.nfs_cpu_limit
  webserver_create         = var.webserver_create
  customer                 = var.customer
  servername               = var.servername
  region                   = var.region
  project                  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
  vpcid                    = var.vpc_id == "" ? data.terraform_remote_state.webserver.outputs.vpc_id : var.vpc_id
  subnetid                 = var.subnet_id == "" ? [data.terraform_remote_state.webserver.outputs.public_subnet_id] : [var.subnet_id]
  securitygroupid          = var.security_group_id == "" ? [data.terraform_remote_state.webserver.outputs.public_security_group_id] : [var.security_group_id]
  master_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.webserver.outputs.master_private_ip]
  worker_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.jobmachine.outputs.compute_private_ip]
  splfs_private_ip         = var.enable_sgo == "false" ? null : [data.terraform_remote_state.nfsmachine.outputs.splfs_private_ips]
  vm_user                  = var.vm_user
  cloud_ssh_port           = var.cloud_ssh_port
  dnsname                  = data.terraform_remote_state.webserver.outputs.dnsname
  mountname                = data.terraform_remote_state.webserver.outputs.mountname
  private_key              = var.enable_sgo == "false" ? var.ssh_keypriv : data.terraform_remote_state.webserver.outputs.private_key
  nfsami_id                = var.spillboxcompute_imageid
  computeami_id            = var.spillboxcompute_imageid
  enable_sgo               = var.enable_sgo
  webserver                = var.webserver
  compute                  = var.compute
  service_userid           = var.service_userid
  nfs                      = var.nfs
  keyname                  = "Notneeded"
  enable_lsfinstall        = var.enable_lsfinstall
  zone                     = "Not needed for the Azure"
  max_spot_count           = "Only needed for AWS"
  max_spot_price           = "Only needed for AWS"
  spot_instance_type       = "Only needed for AWS"
  spot_allocation_strategy = "Only needed for AWS"
  spot_role                = "Only needed for AWS"
  spot_tag                 = var.spot_tag
  compute_tag              = var.compute_tag
  iam_instance_profile     = "only needed for aws"
  nfs_tag                  = var.nfs_tag
  compartment_ocid         = "Not needed"
  subnet_dns               = "Not needed"
  spillbox_container       = var.spillbox_container
  singularity_sifpath      = var.singularity_sifpath
}
