resource "azurerm_virtual_network" "vpc_main" {
  count               = var.vpc_id == "" ? 1 : 0
  name                = "${var.customer}-Main-VPC"
  resource_group_name = var.resource_group_name
  location            = var.location
  address_space       = ["10.0.0.0/16"]
}

# Create a public subnet to launch our load balancers
resource "azurerm_subnet" "public" {
  name                 = "${var.customer}-public"
  resource_group_name  = var.resource_group_name
  virtual_network_name = var.vpc_id == "" ? azurerm_virtual_network.vpc_main[0].name : var.vpc_id
  address_prefixes     = [var.vpc_id == "" ? "10.0.1.0/24" : var.public_subnet_cidr == "" ? "10.0.1.0/24" : var.public_subnet_cidr]
}

