output "public_id" {
  description = "Public subnet id"
  value       = azurerm_subnet.public.id
}


output "vpc_id" {
  description = "VPC id"
  value       = var.vpc_id == "" ? azurerm_virtual_network.vpc_main[0].id : var.vpc_id
}

output "vpc_name" {
  description = "VPC id"
  value       = var.vpc_id == "" ? azurerm_virtual_network.vpc_main[0].name : var.vpc_id
}


output "public_cidr_blocks" {
  description = "Public Network CIDR block"
  value       = [azurerm_subnet.public.address_prefixes]
}


