terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    azurerm = {
      version = "4.17.0"
    }
    null = {
      version = "3.2.3"
    }
    template = {
      version = "2.2.0"
    }
  }
  backend "azurerm" {
    key     = "states/nfs_machine"
    use_msi = true
  }
}

provider "azurerm" {
  features {
    resource_group {
      prevent_deletion_if_contains_resources = false
    }
  }
}

data "terraform_remote_state" "webserver" {
  backend = "azurerm"
  config = {
    resource_group_name  = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
    storage_account_name = "${var.customer}${var.customer_project}"
    container_name       = "${var.customer}"
    key                  = "states/webserver"
    use_msi              = true
  }
}

module "splfs" {
  source                 = "../../azure/compute_nvme/"
  count                  = var.enable_sgo == "false" ? 0 : 1
  number                 = var.min_nfs_count
  Name                   = "${var.servername}-nfs"
  subnet_id              = data.terraform_remote_state.webserver.outputs.public_subnet_id
  customer               = "${var.customer}-${var.servername}"
  key_name               = data.terraform_remote_state.webserver.outputs.key_name
  vpc_security_group_ids = ["Not needed for Azure"]
  ami_name               = var.spillbox_imageid
  ami_plan               = var.base_ami_plan == "" ? data.terraform_remote_state.webserver.outputs.ami_plan : var.base_ami_plan
  instance_type          = var.nfs_instance_type == "" ? var.splfs_instance_type[var.model] : var.nfs_instance_type
  vm_user                = var.vm_user
  public_key             = data.terraform_remote_state.webserver.outputs.public_key
  private_key            = data.terraform_remote_state.webserver.outputs.private_key
  cloud_user             = var.cloud_user
  cache_dir              = var.cache_dir
  model                  = var.model
  data_in_memory         = var.data_in_memory
  project                = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
  dnsname                = data.terraform_remote_state.webserver.outputs.dnsname
  mountname              = data.terraform_remote_state.webserver.outputs.mountname
  zone                   = var.region
  cloud_ssh_port         = var.cloud_ssh_port
  root_volume_size       = var.nfs_volume_size
  nfs_tag                = var.nfs_tag == "" ? "" : "${var.nfs_tag}"
}
