//  The region we will deploy our cluster into.
variable "region" {
  description = "Region to deploy into"
}

variable "storage_account" {}
variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "customer_project" {
  description = "Customer project name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}

variable "min_nfs_count" {}
variable "splfs_instance_type" {
  description = "Provides an EC2 instance resource for splfs server"
  type        = map(string)

  default = {
    small  = "Standard_E2ds_v6"
    medium = "Standard_E2ds_v6"
    large  = "Standard_E2ds_v6"
  }
}


variable "nfs_instance_type" {}
variable "subnet_id" {}
variable "servername" {}
variable "security_group_id" {}
variable "resource_group" {}
variable "cloud_ssh_port" {}
variable "cache_dir" {}
variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}
variable "spillbox_imageid" {}
variable "enable_sgo" {}
variable "cloud_user" {}
variable "nfs_volume_size" {
  default = 50
}
variable "nfs" {}
variable "data_in_memory" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
}
variable "nfs_tag" {}
variable "base_ami_plan" {}
