terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    azurerm = {
        version = "4.17.0"
    }
  }
}

provider "azurerm" {
  features {
    resource_group {
      prevent_deletion_if_contains_resources = false
    }
  }
}

resource "azurerm_resource_group" "resource_group" {
  count    = var.enable_sgo == "false" ? 0 : var.resource_group == "" ? 1 : 0
  name     = "ts-${var.customer}-${var.customer_project}-rg"
  location = var.region
}

resource "azurerm_storage_account" "ts" {
  name                     = "${var.customer}${var.customer_project}"
  resource_group_name      = var.resource_group == "" ? azurerm_resource_group.resource_group[0].name : var.resource_group
  location                 = var.region
  account_tier             = var.storage_account_tier
  account_replication_type = var.storage_replication_type
}

resource "azurerm_storage_container" "Blob" {
  name                  = var.customer
  storage_account_name  = azurerm_storage_account.ts.name
  container_access_type = "blob"
}

resource "azurerm_storage_queue" "Queue" {
  name                 = var.customer
  storage_account_name = azurerm_storage_account.ts.name
}

