# A security group for the ELB so it is accessible via the web
resource "azurerm_network_security_group" "public_elb" {
  name                = "${var.customer}-sec_group_public_elb"
  location            = var.location
  resource_group_name = var.resource_group_name

  tags = {
    Name = var.customer
  }

  security_rule {
    name                       = "ssh"
    priority                   = 400
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "Tcp"
    source_port_range          = "*"
    destination_port_range     = var.cloud_ssh_port
    source_address_prefix      = "*"
    destination_address_prefix = "*"
  }

  security_rule {
    name                       = "All_local"
    priority                   = 150
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "*"
    source_port_range          = "*"
    destination_port_range     = "*"
    source_address_prefixes    = var.public_cidr_blocks[0]
    destination_address_prefix = var.public_cidr_blocks[0][0]
  }

  security_rule {
    name                       = "All_outbound"
    priority                   = 200
    direction                  = "Outbound"
    access                     = "Allow"
    protocol                   = "*"
    source_port_range          = "*"
    destination_port_range     = "*"
    source_address_prefixes    = var.public_cidr_blocks[0]
    destination_address_prefix = "*"
  }
}


