terraform {
  required_providers {
    azurerm = {
      version = "4.17.0"
    }
    local = {
      version = "2.5.2"
    }
    null = {
      version = "3.2.3"
    }
    tls = {
      version = "4.0.6"
    }
  }
}

provider "azurerm" {
  features {}
}

locals {
  key_name = "${var.customer}-${var.customer_project}-auto-key"
  public_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.customer_project,
    local.key_name,
    var.public_key_extension,
  )
  private_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.customer_project,
    local.key_name,
    var.private_key_extension,
  )
}

module "tls_private_key" {
  source               = "../../../modules/ssh_key_pair"
  enabled              = var.generate_ssh_key == "true" ? 1 : 0
  public_key_filename  = local.public_key_filename
  private_key_filename = local.private_key_filename
}

