output "vpc_id" {
  value = var.vpc_id == "" ? module.subnet[0].vpc_id : var.vpc_id
}

output "public_subnet_id" {
  value = var.subnet_id == "" ? module.subnet[0].public_id : var.subnet_id
}

output "key_name" {
  value = module.ssh_key_pair.key_name
}

output "public_security_group_id" {
  value = var.security_group_id == "" ? module.security_group[0].public_id : var.security_group_id
}


output "private_key" {
  value = module.ssh_key_pair.private_key_filename
}

output "public_key" {
  value = module.ssh_key_pair.public_key_filename
}

output "vm_user" {
  value = var.vm_user
}

output "customer" {
  value = var.customer
}

output "customer_id" {
  value = var.customer
}

output "cache_dir" {
  value = var.cache_dir
}

output "cloud_provider" {
  value = var.cloud_provider
}

output "customer_project" {
  value = var.customer_project
}


output "project" {
  value = var.resource_group == "" ? "ts-${var.customer}-${var.customer_project}-rg" : var.resource_group
}

output "region" {
  value = var.region
}


output "public_subnet_cidr" {
  value = var.subnet_id == "" ? module.subnet[0].public_cidr_blocks[0][0] : ""
}

output "max_ch_cap" {
  value = var.max_ch_cap
}

output "cloud_ssh_port" {
  value = var.cloud_ssh_port
}

output "master_private_ip" {
  value = var.enable_sgo == "false" ? [[var.webserver[0][0]]] : module.webserver[0].private_ip
}
output "mountname" {
  value = "/${var.storage_account}nfs/sharename"
}

output "dnsname" {
  value = azurerm_private_endpoint.file.private_service_connection[0].private_ip_address
}
output "ami_plan" {
   value = module.webserver[0].ami_plan
}
