//  The region we will deploy our cluster into.
variable "region" {
  description = "Region to deploy into"

  //  The default below will be fine for many, but to make it clear for first
  //  time users, there's no default, so you will be prompted for a region.
}

variable "storage_account" {}
variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "customer_project" {
  description = "Customer project name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}

variable "cache_dir" {
  description = "Directory where cached prem and generated cloud data reside"
}

variable "cloud_user" {
  description = "On prem unix username"
}

variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}


variable "secrets" {
  type        = string
  description = "Path to SSH public key directory (e.g. `/secrets`)"
}

variable "wan_timeout" {
  type        = number
  description = "Designated host to create/destroy projects"
}

variable "max_ch_cap" {
  type        = number
  description = "WAN throughput size"
}

variable "data_in_memory" {
  type        = bool
  description = "File system in memory, not on disk"
}

variable "vpc_id" {}
variable "resource_group" {}
variable "cloud_ssh_port" {}

variable "public_subnet_cidr" {
  description = "Customer's public subnet CIDR"
}
variable "subnet_id" {}
variable "servername" {}
variable "security_group_id" {}
variable "base_ami_name" {}
variable "splpipe_instance_type" {
  description = "Provides an EC2 instance resource splpipe server"
  type        = map(string)

  default = {
    small  = "Standard_D2s_v3"
    medium = "Standard_D4s_v3"
    large  = "Standard_D8s_v3"
  }
}
variable "webserver_instance_type" {}
variable "enable_sgo" {}
variable "webserver_volume_size" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
  default     = null
}
variable "compute" {}
variable "nfs" {}
variable "clientid" {}
variable "tenantid" {}
variable "clientsecret" {}
variable "docker_registry" {}
variable "docker_images" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "base_ami_plan" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
