data "template_file" "config" {
  template = file("${path.module}/init.tpl")
  vars = {
    cloud_ssh_port = var.cloud_ssh_port
}
  }
data "template_file" "attach_nvme" {
  template = file("${path.module}/scripts/ebs_mount.sh.tpl")
  vars = {
    volume_name = "/dev/md0"
    mount_point = "/SCRATCH"
    file_system = "ext4"
    inmemory    = false
    limit       = "50"
    tmpfs_size  = "0"
  }
}

data "template_cloudinit_config" "config" {
  gzip          = false
  base64_encode = false

  part {
    content_type = "text/x-shellscript"
    content      = data.template_file.config.rendered
  }
# part {
 #   content_type = "text/x-shellscript"
  #  content      = data.template_file.alias_nvme.rendered
  #}
  part {
    content_type = "text/x-shellscript"
    content      = data.template_file.attach_nvme.rendered
  }
}
