#!/bin/bash -f

# Find ephemeral disks
ROOT_DEVICE=$(df / | awk 'NR==2 {print $1}' | xargs lsblk -no PKNAME)

if [[ "$ROOT_DEVICE" == nvme* ]]; then
        VOLUMES_NAME=$(find /dev | grep -E 'nvme[1-2]n1$|sd[a-z]$')
else
        VOLUMES_NAME=$(find /dev | grep -E 'nvme[0-2]n1$|sd[b-z]$')
fi
echo ${VOLUMES_NAME[@]} | tr " " "\n"

ephemeral_disks=""
declare -i DISK_COUNT
for VOLUME in ${VOLUMES_NAME}
do
 DISK=$(sudo nvme id-ctrl -v "${VOLUME}")
 if [ ! -z "${DISK}" ]; then
  let DISK_COUNT++
  echo "Added disk ${VOLUME}, ${DISK_COUNT} so far"
  ephemeral_disks="${ephemeral_disks} ${VOLUME}"
 fi
done

# Create a filesystem on the disks (example: xfs)
for disk in ${ephemeral_disks}; do
    #mkfs.xfs $${disk}
    yes | sudo mkfs.ext4 -F ${disk}
done

# Create a RAID0 array (replace with your desired name)
sudo mdadm --create /dev/md0 --level=raid0 --raid-devices=${DISK_COUNT} ${ephemeral_disks} --force --run

sudo mkdir -p /SCRATCH

yes | sudo mkfs.ext4 -F /dev/md0

sudo mount "/dev/md0" /SCRATCH
if test ${PIPESTATUS[0]} -ne 0 ; then
    echo "Mount Failed"
fi
