#!/bin/bash -f
#echo $1:spillbox_container $2: vm_user  $3:master_private_ip $4:docker_registry $5:docker_images $6:service_userid
SPILLBOX_CONTAINER="${1}"
CLOUD_USER="${2}"
MASTER_IP="${3}"
DOCKER_REGISTRY="${4}"
DOCKER_IMAGES="${5}"
SERVICE_USERID="${6}"

centos=0
OSID=$(cat /etc/os-release | grep ^ID= | awk -F= '{print $2}' | sed 's/"//g')
UPDATE="update -y"
CHRONYCONF="/etc/chrony/chrony.conf"
APT="apt-get"
if [[ $OSID == "centos" ]] || [[ "$OSID" == "rhel" ]]; then
    APT="yum"
    centos=1
    UPDATE="check-update --skip-broken -y"
    CHRONYCONF="/etc/chrony.conf"
    centos_version=$(rpm -E %{rhel})
    if [[ -f /etc/centos-release && ( "$centos_version" == "7" || "$centos_version" == "8" ) ]]; then
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/mirror.centos.org/vault.centos.org/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^#.*baseurl=http/baseurl=http/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^mirrorlist=http/#mirrorlist=http/g' {} +
    fi
fi

if [[ $OSID == "amzn" ]]; then
    APT="yum"
    UPDATE="check-update --skip-broken -y"
    alinux=1
fi


if [[ "$SPILLBOX_CONTAINER" == "singularity" ]]; then
    sudo mkdir -p /spillbox_sif
    sudo chmod 777 /spillbox_sif
fi

echo enable chrony
sudo $APT remove -y ntp
sudo $APT install -y chrony
echo "server 169.254.169.123 prefer iburst" | sudo tee -a $CHRONYCONF
service_user="sbox"
if [ "$SERVICE_USERID" == "" ] ; then
    free_uid=$(awk -F: '{uid[$3]=1}END{for(x=2000;x<=10000;x++)if(!uid[x]){print x;exit}}' /etc/passwd /etc/group)
    sudo groupadd -g $free_uid $service_user
    sudo useradd -u $free_uid -g $free_uid $service_user
else
    uid=$(echo $SERVICE_USERID | awk -F ':' '{print $1}')
    gid=$(echo $SERVICE_USERID | awk -F ':' '{print $2}')
    service_user=$(echo $SERVICE_USERID | awk -F ':' '{print $3}')
    sudo groupadd -g $gid $service_user
    sudo useradd -u $uid -g $gid $service_user
fi

if [[ $centos -eq 1 || $alinux -eq 1 ]]; then
    sudo $APT install -y bind-utils
    sudo /usr/sbin/chronyd
else
    sudo $APT install -y dnsutils
    sudo systemctl enable chrony
    sudo systemctl --no-pager start chrony
    sudo systemctl --no-pager status chrony
fi
sudo chronyc makestep
if ! timedatectl | grep -q "synchronized: yes" ; then
    PID=$( ps aux | grep -v grep | grep /usr/sbin/chronyd | awk '{print $2}')
    if [ "${PID}" != "" ]; then
        sudo kill -9 $PID
    fi
    sleep 10
    sudo /usr/sbin/chronyd
    sudo chronyc makestep
fi
sudo systemctl stop firewalld.service

sudo systemctl stop firewalld.service
if [[ $centos -eq 1 || $alinux -eq 1 ]]; then
    sudo $APT $UPDATE
    sudo $APT install -y yum-utils nfs-utils
    sudo $APT install -y bind-utils
    sudo $APT install -y wget unzip curl
    if [ "$OSID" == "rhel" ]; then
        rhel_version=$(rpm -E %{rhel})
        wget -P /tmp https://dl.fedoraproject.org/pub/epel/epel-release-latest-${rhel_version}.noarch.rpm
        sudo $APT install -y /tmp/epel-release-latest-${rhel_version}.noarch.rpm
    elif test $alinux -eq 1 ; then
        sudo amazon-linux-extras install -y epel
    else
        sudo $APT install -y epel-release
    fi
    sudo $APT install -y unzip curl mdadm nvme-cli
    sudo $APT install -y vim patchelf jq ed java-1.8.0-openjdk-devel 
    sudo $APT install -y cachefilesd
    sudo $APT install -y rsync 
    sudo $APT install -y libnsl
    sudo service rpc-statd start
    sudo systemctl enable rpc-statd
    tmp=$(sudo systemctl is-enabled rpc-statd)
    if [ "$tmp" != "enabled" ]; then
        sudo ln -s /usr/lib/systemd/system/rpc-statd.service /etc/systemd/system/multi-user.target.wants/
        ls -l /etc/systemd/system/multi-user.target.wants/rpc-statd.service
    fi
    #Providing sudo power to user and setting no passwd
    sudo usermod -aG wheel $service_user
    echo "${service_user} ALL=(ALL) NOPASSWD:ALL" | sudo tee -a /etc/sudoers.d/99_sudouser
else
    sudo $APT $UPDATE
    sudo $APT install -y  dnsutils
    sudo $APT install -y vim patchelf wget jq unzip curl mdadm nvme-cli
    sudo $APT install -y cachefilesd
    sudo $APT install -y  ca-certificates curl gnupg
    sudo $APT install -y nfs-common
    #Providing sudo power to user and setting no passwd
    sudo usermod -aG sudo $service_user
    echo "${service_user} ALL=(ALL) NOPASSWD:ALL" | sudo tee -a /etc/sudoers.d/99_sudouser
fi

#installing juicefs
if ! command -v juicefs &> /dev/null ; then
    echo "Installing Juicefs"
    sudo curl -sSL https://d.juicefs.com/install | sh -
fi

#disabling selinux
status=$(sudo getenforce)
if [[ "$status" == "Enforcing" || "$status" == "Permissive" ]]; then
    sudo sed -i 's/^SELINUX=.*/SELINUX=disabled/' /etc/selinux/config
fi

#installing python
if command -v python &> /dev/null; then
    PYTHON_VERSION=$(python --version 2>&1)
    if  ! [[ $PYTHON_VERSION == *"Python 2"* || $PYTHON_VERSION == *"Python 3"* ]]; then
        sudo $APT install -y python3
        sudo ln -s "$(which python3)" /usr/bin/python
        sudo $APT install -y python2
    fi
else
    sudo $APT install -y python3
    sudo ln -s "$(which python3)" /usr/bin/python
    sudo $APT install -y python2
fi

if [ "$SPILLBOX_CONTAINER" == "docker" ]; then
    which docker > /dev/null
    ret=$?
    if test $ret -ne 0 ; then
        if [[ "$OSID" == "centos" ]]; then
            sudo yum-config-manager --add-repo https://download.docker.com/linux/centos/docker-ce.repo
            sudo $APT install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
        elif [[ "$OSID" == "rhel" ]]; then
             sudo yum-config-manager --add-repo https://download.docker.com/linux/rhel/docker-ce.repo
             sudo $APT install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
        elif [[ $alinux -eq 1 ]]; then
            sudo amazon-linux-extras install docker -y
            sudo $APT install -y docker
        else
            sudo install -m 0755 -d /etc/apt/keyrings
            sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /etc/apt/keyrings/docker.gpg
            sudo chmod a+r /etc/apt/keyrings/docker.gpg
            echo \
            "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.gpg] https://download.docker.com/linux/ubuntu \
            $(. /etc/os-release && echo "$VERSION_CODENAME") stable" | \
            sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
            sudo $APT $UPDATE
            sudo $APT install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
        fi
    fi
    sudo systemctl enable docker
    sudo systemctl start docker
    which docker > /dev/null
    ret=$?
    if test $ret -ne 0 ; then
        echo "Docker installation Failed..." 2>&1 | tee /dev/stderr
        exit 1
    fi
    sudo usermod -aG docker ${CLOUD_USER}
    sudo usermod -aG docker $service_user
    tmp=$(echo $DOCKER_REGISTRY | awk -F ':' '{print $1}')
    if [ "$tmp" != "" ]; then
        add_reg="$DOCKER_REGISTRY"
        REG_SET="true"
    else
        add_reg=""
    fi
    file="/etc/docker/daemon.json"
    tmpfile="/tmp/daemon.json"
    registries="${MASTER_IP}:5000 ${add_reg}"
    for registry in ${registries}
    do
        if [[ -f /etc/docker/daemon.json && "`sudo cat /etc/docker/daemon.json 2> /dev/null`" != "" ]]; then
            tmp=$(sudo jq '.["insecure-registries"]' "$file" 2> /dev/null)
            if [ "$tmp" != "null" ]; then
                if `sudo jq --arg registry "${registry}" 'any(.["insecure-registries"][] == $registry; .)' "$file"` == "true" ; then
                    echo "The registry $registry is already present in $file"
                else
                    sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                    sudo mv "$tmpfile" "$file"
                    echo "Registry value added successfully."
                fi
            else
                echo "Registry value added successfully."
                sudo jq --arg registry "${registry}" '.["insecure-registries"] += [$registry]' "$file" > "$tmpfile"
                sudo mv "$tmpfile" "$file"
            fi
        else
            #create an new daemon json file
            sudo bash -c "cat << END >> /etc/docker/daemon.json
{
    \"hosts\": [\"unix:///var/run/docker.sock\",\"tcp://0.0.0.0:2375\"],
    \"insecure-registries\": [\"${registry}\"]
}
END"
        fi
    done
    #internal debug will optimize it before production
    sudo cat /etc/docker/daemon.json
    sudo cp /lib/systemd/system/docker.service /etc/systemd/system/
    sudo bash -c "sed -i 's/\ -H\ fd:\/\///g' /etc/systemd/system/docker.service"
    sudo systemctl daemon-reload
    sudo service docker restart
    if [[ "$DOCKER_IMAGES" != ""  && "$REG_SET" == "true" ]]; then
        IFS=' ' read -ra images_array <<< "$DOCKER_IMAGES"
        for image in "${images_array[@]}"; do
            sudo su - "${CLOUD_USER}" -c "docker pull ${DOCKER_REGISTRY}/${image}"
            sudo su - "${CLOUD_USER}" -c "docker tag ${DOCKER_REGISTRY}/${image} ${image}"
        done
    else
        #Creating registry
        sudo su - "${CLOUD_USER}" -c "docker pull registry"
        sudo su - "${CLOUD_USER}" -c "docker run -d -p 5000:5000 --restart=always --name spillbox_registry registry"
    fi
    # for juicefs, we use redis database
    sudo su - "${CLOUD_USER}" -c "docker pull redis"
else
    if [[ "$centos" -eq 1 ]] || [[ "$OSID" == "rhel" ]]; then
        sudo $APT groupinstall -y 'Development Tools'
        sudo $APT install -y autoconf automake cryptsetup fuse fuse3 fuse3-devel git glib2-devel libseccomp-devel libtool squashfs-tools zlib-devel make
    else
        sudo apt-get $UPDATE
        sudo apt-get install -y autoconf automake cryptsetup fuse2fs git fuse libfuse-dev libglib2.0-dev libseccomp-dev libtool pkg-config runc squashfs-tools uidmap zlib1g-dev make
    fi
    #Installing go
    pushd /tmp
    export VERSION=1.22.6 OS=linux ARCH=amd64
    wget https://dl.google.com/go/go$VERSION.$OS-$ARCH.tar.gz
    sudo tar -C /usr/local -xzvf go$VERSION.$OS-$ARCH.tar.gz
    rm go$VERSION.$OS-$ARCH.tar.gz

    # Update PATH for Go
    echo "Updating PATH for Go..."
    echo 'export PATH=/usr/local/go/bin:$PATH' >> ~/.bashrc
    source ~/.bashrc
    echo "Installing Singularity version 4.2.0..."
    export VERSION=4.2.0
    wget https://github.com/sylabs/singularity/releases/download/v${VERSION}/singularity-ce-${VERSION}.tar.gz
    tar -xzf singularity-ce-${VERSION}.tar.gz
    if [ -d "singularity-ce-${VERSION}" ]; then
        cd singularity-ce-${VERSION}
    else
        echo "Singularity directory not found. Exiting." 2>&1 | tee /dev/stderr
        exit 1
    fi

    # Configure, build and install Singularity
    echo "Configuring and installing Singularity..."
    ./mconfig
    make -C builddir
    sudo make -C builddir install
    cd ..
    rm -rf singularity-ce-${VERSION}
    popd
fi
maxfd=$(ulimit -Hn)
if test $maxfd  -lt 1024000 ; then
    sudo bash -c 'cat <<END >> /etc/security/limits.conf
*                soft    nofile          1024000
*                hard    nofile          1024000
END'
fi

host=$(hostname -s)
#lsf-installiation
sudo mkdir -p /sbox_lsf
sudo chmod 777 /sbox_lsf
mkdir -p /sbox_lsf/lsf /sbox_lsf/lsf_install
sudo chmod 777 -R /sbox_lsf/lsf /sbox_lsf/lsf_install
cp /tmp/lsf_std_entitlement.dat /sbox_lsf/lsf_install/lsf_std_entitlement.dat
sudo rm -f /tmp/lsf_std_entitlement.dat
cd /sbox_lsf/lsf_install ; curl -O https://s3.us-west-1.amazonaws.com/spillbox.io-internal/lsf_tarfiles.tar.gz ; tar xvf lsf_tarfiles.tar.gz
cd /sbox_lsf/lsf_install ; tar xvf ./lsf_tarfiles/lsf10.1_lsfinstall_linux_x86_64.tar.Z
cd /sbox_lsf/lsf_install ; curl -O https://s3.us-west-1.amazonaws.com/spillbox.io-internal/lsf10.1_lnx310-lib217-x86_64-601547.tar.Z
if [ -f "/sbox_lsf/lsf_install/lsf10.1_lsfinstall/server.config" ]; then
        echo "server.config is present"
else
        echo "server.config not found" 2>&1 | tee /dev/stderr
        exit 1
fi

conf_file="/sbox_lsf/lsf_install/lsf10.1_lsfinstall/server.config"
echo "LSF_TOP=\"/sbox_lsf/lsf\"" >> $conf_file
echo "LSF_ADMINS=\"${1} ${service_user}\""  >> $conf_file
echo "LSF_TARDIR=\"/sbox_lsf/lsf_install/lsf_tarfiles\"" >> $conf_file
echo "LSF_ENTITLEMENT_FILE=\"/sbox_lsf/lsf_install/lsf_std_entitlement.dat\""  >> $conf_file
echo "LSF_SERVER_HOSTS=\"${host}\""  >> $conf_file
echo "LSF_LOCAL_RESOURCES=\"[resource googlehost]\""  >> $conf_file
echo "LSF_LIM_PORT=\"7869\"" >> $conf_file
echo "ACCEPT_LICENSE=\"Y\"" >> $conf_file

cd /sbox_lsf/lsf_install/lsf10.1_lsfinstall/ ; yes 1 | sudo  ./lsfinstall -s -f server.config


if [ -f /sbox_lsf/lsf/conf/profile.lsf ]; then
        . /sbox_lsf/lsf/conf/profile.lsf
else
        echo "no source file found " 2>&1 | tee /dev/stderr
        exit 1
fi

sudo -E /sbox_lsf/lsf/10.1/install/patchinstall --silent /sbox_lsf/lsf_install/lsf10.1_lnx310-lib217-x86_64-601547.tar.Z
