variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "servername" {
  description = "server tag name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}

variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}

variable "compute_instance_type" {}
variable "job_instance_type" {
  description = "Provides an EC2 instance resource for slurm master"
  type        = map(string)

  default = {
    small  = "n1-standard-1"
    medium = "n1-standard-2"
    large  = "n1-standard-4"
  }
}
variable "base_ami_name" {}
variable "cloud_ssh_port" {}
variable "project_public_key" {}
variable "project_private_key" {}
variable "enable_sgo" {}
variable "compute_volume_size" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
}
variable "compute" {}
variable "nfs" {}
variable "zone" {}
variable "project" {}
variable "google_credentials" {}
variable "docker_registry" {}
variable "docker_images" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "kms_key_id" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
variable "docker_baseami_id" {}
variable "disable_compute_public_ips" {
  default = true
}
