# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    google = {
        version = "6.19.0"
    }
    null = {
        version = "3.2.3"
    }
  }
  backend "gcs" {
    prefix = "states/lsf"
  }
}

provider "google" {
  region      = var.region
  project     = var.project
  credentials = var.google_credentials
}
data "terraform_remote_state" "webserver" {
  backend = "gcs"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    prefix = "states/webserver"
  }
}
data "terraform_remote_state" "nfs-machine" {
  backend = "gcs"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    prefix = "states/nfs-machine"
  }
}
data "terraform_remote_state" "job-machine" {
  backend = "gcs"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    prefix = "states/job-machine"
  }
}
module "installsf" {
  source                   = "../../../modules/lsf/"
  cloud_provider           = var.cloud_provider
  min_compute_number       = var.min_compute_count
  min_nfs_number           = var.min_nfs_count
  max_compute_number       = var.max_compute_count
  max_nfs_number           = var.max_nfs_count
  compute_instance_type    = var.compute_instance_type == "" ? "n1-standard-1" : var.compute_instance_type
  nfs_instance_type        = var.nfs_instance_type == "" ? "n1-highmem-2" : var.nfs_instance_type
  nfs_cpu_limit            = var.nfs_cpu_limit
  iam_instance_profile     = "only needed for aws"
  webserver_create         = var.webserver_create
  customer                 = var.customer
  servername               = var.servername
  region                   = var.region
  project                  = var.project
  vpcid                    = var.vpc_id == "" ? data.terraform_remote_state.webserver.outputs.vpc_id : var.vpc_id
  subnetid                 = var.subnet_id == "" ? [data.terraform_remote_state.webserver.outputs.public_subnet_id] : [var.subnet_id]
  securitygroupid          = var.security_group_id == "" ? [data.terraform_remote_state.webserver.outputs.public_security_group_id] : [var.security_group_id]
  master_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.webserver.outputs.master_private_ip]
  worker_private_ip        = var.enable_sgo == "false" ? null : [data.terraform_remote_state.job-machine.outputs.compute_private_ip]
  splfs_private_ip         = var.enable_sgo == "false" ? null : [data.terraform_remote_state.nfs-machine.outputs.splfs_private_ips]
  vm_user                  = var.vm_user
  cloud_ssh_port           = var.cloud_ssh_port
  nfsami_id                = var.spillboxcompute_imageid
  computeami_id            = var.spillboxcompute_imageid
  private_key              = var.enable_sgo == "false" ? var.ssh_keypriv : var.project_private_key
  dnsname                  = data.terraform_remote_state.webserver.outputs.dnsname
  mountname                = data.terraform_remote_state.webserver.outputs.mountname
  enable_sgo               = var.enable_sgo
  webserver                = var.webserver
  service_userid           = var.service_userid
  compute                  = var.compute
  nfs                      = var.nfs
  keyname                  = "Notneeded"
  enable_lsfinstall        = var.enable_lsfinstall
  zone                     = var.zone
  max_spot_count           = "Only needed for AWS"
  max_spot_price           = "Only needed for AWS"
  spot_instance_type       = "Only needed for AWS"
  spot_allocation_strategy = "Only needed for AWS"
  spot_role                = "Only needed for AWS"
  spot_tag                 = var.spot_tag
  compute_tag              = var.compute_tag
  nfs_tag                  = var.nfs_tag
  compartment_ocid         = "Not needed"
  subnet_dns               = "Not needed"
  spillbox_container       = var.spillbox_container
  singularity_sifpath      = var.singularity_sifpath
}
